set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8037293';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3023',
      NULL,
      NULL,
      '00443243',
      '44202441',
      '22013024',
      '10242424',
      '44030034',
      '14404313',
      '42133224',
      '14333031',
      '13134332',
      '30021204',
      '32042232',
      '41143421',
      '13333123',
      NULL,
      '21323322',
      '10344231',
      '22344420',
      '02032224',
      '14030111',
      '33102232',
      '30133234',
      '34432042',
      '00003302',
      '11013334',
      '12024034',
      '24024022',
      '11223403',
      '04030223',
      '42333014',
      '03231012',
      '20233442',
      '41144142',
      '30011310',
      '42141331',
      '24202010',
      '00204111',
      NULL,
      '04343302',
      '14021412',
      '20233101',
      '02213231',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '0323044',
      NULL,
      0.227038,
      NULL,
      NULL,
      '141122',
      3,
      NULL,
      ' 9-13-1981',
      57,
      NULL,
      NULL,
      23,
      20,
      10.820157,
      NULL,
      2.518650,
      2.690469,
      21.838331,
      30.403771,
      29.507941,
      NULL,
      NULL,
      20,
      20.693258,
      31.056368,
      16,
      60.197911,
      19.668159,
      23.612302,
      NULL,
      41.736919,
      16,
      NULL,
      123.295234,
      81.735619,
      122.635495,
      180.956884,
      255.422476,
      48,
      ' 2-12-2003',
      4.027797,
      10.524518,
      19,
      8,
      NULL,
      149.044912,
      NULL,
      3.881767,
      2.250085,
      2.807680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.584411,
      7,
      0.556452,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-27-1996',
      0,
      25,
      95,
      8.875610,
      83,
      55,
      NULL,
      77.753990,
      90.347029,
      108,
      31,
      39.768058,
      '11- 5-1984',
      42,
      19.954470,
      7.032945,
      16,
      NULL,
      20,
      4,
      ' 9-16-1985',
      18,
      22.342603,
      ' 7- 4-1994',
      NULL,
      7.683253,
      9,
      2.255812,
      0.961027,
      9,
      NULL,
      NULL,
      NULL,
      109.994112,
      0,
      2,
      1.318133,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 5-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31,
      2,
      NULL,
      ' 7- 8-1996',
      3,
      109.431940,
      NULL,
      2.790074,
      9,
      0,
      NULL,
      '11- 1-1995',
      52,
      1,
      140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      52.905890,
      97.513413,
      NULL,
      NULL,
      84,
      0.768739,
      13.534795,
      0.748486,
      NULL,
      10,
      NULL,
      4.557296,
      1.324839,
      48.033176,
      NULL,
      NULL,
      23.998984,
      0,
      0.636743,
      NULL,
      2,
      0,
      165,
      NULL,
      26,
      NULL,
      1.863086,
      NULL,
      0,
      1,
      0.259325,
      0.597685,
      0.027317,
      1.253258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      40.388777,
      0,
      1,
      0.448674,
      61.210510,
      0.893532,
      NULL,
      NULL,
      NULL,
      0.213973,
      NULL,
      NULL,
      5,
      1,
      19,
      NULL,
      NULL,
      12.357562,
      NULL,
      6.705452,
      NULL,
      1.960719,
      3.824782,
      0.380657,
      0,
      NULL,
      6.022350,
      NULL,
      '11- 8-1982',
      NULL,
      ' 5- 9-2000',
      ' 7-11-1992',
      ' 0- 9-1987',
      '10-20-1997',
      NULL,
      NULL);
commit;
end;
/


