set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8723387';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3334',
      '03341023',
      '10111213',
      NULL,
      '22044314',
      '14342241',
      NULL,
      '41110421',
      NULL,
      '33434001',
      '34410212',
      '24102220',
      '22202132',
      '21413140',
      '41313023',
      '34033030',
      NULL,
      '01011121',
      '23134101',
      '14042011',
      '23140121',
      NULL,
      NULL,
      '32000144',
      '20111101',
      '04310224',
      '33003111',
      '31232323',
      '31341102',
      '22243441',
      '23322342',
      '03124241',
      NULL,
      '41031303',
      '23014330',
      '13243340',
      NULL,
      '04201002',
      '42312102',
      '00423211',
      NULL,
      '40231404',
      NULL,
      NULL,
      NULL,
      '003',
      '01',
      NULL,
      NULL,
      NULL,
      3.709763,
      0.431922,
      1,
      NULL,
      '310103',
      3,
      ' 8- 0-1983',
      ' 1-16-1978',
      11,
      NULL,
      32.872370,
      16.484501,
      22,
      NULL,
      49,
      3,
      20,
      NULL,
      36,
      18.531523,
      2.671621,
      NULL,
      10.871277,
      2.302877,
      10.766166,
      26.315752,
      NULL,
      0.214236,
      NULL,
      1,
      116,
      6,
      3,
      NULL,
      NULL,
      127.449535,
      12.858262,
      153.996138,
      161,
      ' 0-16-1996',
      0,
      NULL,
      22.748149,
      NULL,
      39,
      28,
      NULL,
      1,
      1.365807,
      1,
      NULL,
      0,
      1,
      3,
      0.909224,
      NULL,
      1.783091,
      1.342490,
      0.596382,
      1.130045,
      NULL,
      1,
      NULL,
      NULL,
      1.190681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-28-2003',
      85,
      8.649092,
      13,
      2,
      0,
      4,
      NULL,
      0,
      0.119809,
      189,
      2.674731,
      5.135258,
      NULL,
      2.827210,
      NULL,
      16,
      1.427058,
      0,
      40,
      ' 1-19-1989',
      NULL,
      47.199870,
      36.316926,
      57.919146,
      21,
      100,
      33.546056,
      7.301113,
      20.688970,
      25,
      51,
      70.892310,
      '10-10-1980',
      15,
      22,
      NULL,
      58.533278,
      55,
      52,
      6,
      ' 6-20-1995',
      19.769961,
      18.218203,
      ' 3-23-1992',
      2.109623,
      0.775170,
      22,
      2.219723,
      0,
      6,
      1,
      0,
      NULL,
      107.728864,
      1.194307,
      NULL,
      20.295295,
      25,
      0.825537,
      0.396623,
      NULL,
      1.301229,
      ' 8-26-1982',
      0,
      2.488523,
      NULL,
      ' 6-25-1979',
      86.031330,
      0.159610,
      ' 7-10-1981',
      16.326872,
      3.469127,
      ' 6-23-1985',
      53,
      '11-24-1974',
      NULL,
      '11-26-1993',
      NULL,
      6,
      NULL,
      41.677911,
      5.403129,
      ' 8- 0-1990',
      NULL,
      11,
      ' 8-26-1992',
      3.683687,
      1.621941,
      ' 3- 8-1976',
      1,
      NULL,
      NULL,
      NULL,
      17.489668,
      1,
      NULL,
      '10-10-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.723309);
commit;
end;
/


