set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7614186';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      NULL,
      '0',
      NULL,
      '1',
      NULL,
      NULL,
      '0',
      '3',
      '2',
      '3',
      '0',
      '4',
      NULL,
      '3',
      '4',
      '0',
      '1',
      '4',
      '1',
      '2',
      '2',
      '3',
      '',
      '3',
      '',
      NULL,
      NULL,
      '3',
      '0',
      '4',
      '',
      '',
      '3',
      '0',
      '0',
      NULL,
      '2',
      '3',
      NULL,
      '0',
      '3',
      '0',
      '2',
      NULL,
      '11344314',
      30.069680,
      29.074901,
      NULL,
      3.834816,
      NULL,
      3,
      NULL,
      '332012',
      6,
      ' 1-24-1975',
      ' 5-12-1985',
      57,
      NULL,
      5,
      12.471367,
      23,
      2,
      23,
      NULL,
      2.345388,
      3.919752,
      5.143277,
      9.743856,
      16.046606,
      6.557683,
      0.145002,
      4,
      19,
      7,
      NULL,
      4.429817,
      0.379868,
      13.509102,
      64.538413,
      2,
      0.175309,
      42,
      156,
      40.137929,
      50,
      54,
      73.638705,
      ' 1- 0-1987',
      6.282832,
      0,
      21.368757,
      15.987077,
      19.862833,
      134.303030,
      ' 2-26-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      1.299698,
      11.102162,
      8,
      4,
      ' 5- 6-1978',
      NULL,
      0.643964,
      68.937363,
      2.480190,
      0,
      59,
      1.423032,
      0,
      19.453185,
      NULL,
      NULL,
      NULL,
      ' 8- 1-1990',
      38,
      2.236966,
      NULL,
      12.790430,
      13.211100,
      109.008321,
      NULL,
      41,
      18,
      21.564701,
      38,
      8,
      NULL,
      15.943423,
      13.635256,
      7.542515,
      20.803935,
      19,
      18,
      NULL,
      ' 1- 2-1996',
      8,
      NULL,
      ' 9-20-1996',
      7,
      NULL,
      7.251846,
      25.879642,
      6.879342,
      8.440088,
      1.225418,
      NULL,
      1,
      70,
      1,
      1,
      10.170007,
      18.429768,
      0,
      2,
      0,
      1.387777,
      '11- 3-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      82,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      40,
      ' 5-26-1991',
      35,
      '11-16-1976',
      NULL,
      11.953507,
      ' 0- 2-1990',
      NULL,
      73.917380,
      ' 1- 7-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      11,
      ' 6-23-1996',
      40,
      14,
      NULL,
      ' 5-16-1978',
      0,
      NULL,
      NULL,
      6,
      NULL,
      22,
      NULL,
      NULL,
      30,
      0,
      120,
      ' 0-27-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


