set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9209266';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2132',
      '04101332',
      '33244200',
      '23242114',
      NULL,
      '33332120',
      NULL,
      '34440144',
      NULL,
      NULL,
      '30400433',
      '32201002',
      NULL,
      '00330424',
      NULL,
      '31023422',
      '14323110',
      NULL,
      '13200032',
      '42021001',
      '02320403',
      '34403220',
      '31401034',
      NULL,
      '13213001',
      '10042423',
      '20444312',
      NULL,
      '22203140',
      '32324430',
      '01041430',
      '21143002',
      '31110314',
      '13332011',
      '33114032',
      '13232304',
      '32304004',
      '11142300',
      NULL,
      '20111241',
      '24310043',
      '33442224',
      '04232243',
      '24004104',
      '43134241',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.772096,
      0,
      NULL,
      NULL,
      '242304',
      NULL,
      '10-25-1999',
      ' 7-24-1980',
      NULL,
      NULL,
      25,
      19,
      22.241558,
      NULL,
      60.484720,
      13,
      4,
      10.908471,
      NULL,
      NULL,
      37.394426,
      1.849769,
      28,
      3,
      13.326541,
      3,
      43.585744,
      9.294922,
      11,
      20.900586,
      12,
      NULL,
      1,
      0.327363,
      NULL,
      90,
      82.395801,
      71,
      117,
      NULL,
      45,
      49.246195,
      14.936738,
      11,
      89,
      178,
      ' 3- 8-1991',
      1.975315,
      3,
      NULL,
      0.970217,
      0.512348,
      1.708950,
      NULL,
      1.146497,
      0.157307,
      0,
      1.302039,
      0.398846,
      0,
      1,
      1.623308,
      1,
      NULL,
      0,
      NULL,
      1.995340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27.172818,
      16.935478,
      5.432365,
      7,
      4.508400,
      2,
      ' 8-27-1991',
      1.468338,
      0,
      54.135627,
      0,
      1,
      147,
      NULL,
      0.896066,
      8.072066,
      NULL,
      NULL,
      NULL,
      '11-26-1992',
      8.533142,
      5,
      111.940584,
      72,
      12,
      44.894328,
      NULL,
      13,
      74,
      62.279633,
      88,
      86,
      ' 1- 3-1982',
      20.958100,
      5.087874,
      1.213005,
      39,
      40,
      88.531659,
      4,
      ' 8-19-1996',
      11,
      NULL,
      '11- 5-1980',
      11,
      6,
      5,
      26,
      21,
      7.390520,
      1.487274,
      11.755726,
      0.408253,
      76,
      1.810796,
      5.970168,
      3.435785,
      23,
      1.909859,
      0,
      1.065960,
      1,
      '11-20-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      8,
      ' 8-23-1983',
      NULL,
      NULL,
      NULL,
      55,
      NULL,
      48.359935,
      ' 5-26-1991',
      13.819582,
      3.421259,
      ' 1-16-1983',
      102,
      NULL,
      ' 1-13-1989',
      3.679172,
      0,
      '10- 1-1974',
      NULL,
      NULL,
      NULL,
      1,
      2,
      10.787082,
      ' 9-13-1979',
      NULL,
      9,
      56.584616,
      ' 0-20-1990',
      NULL,
      70,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


