set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9134475';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0102',
      NULL,
      '44144241',
      '14440120',
      '12044332',
      NULL,
      '03024422',
      '30104332',
      '41102240',
      '22140130',
      NULL,
      '01233402',
      '30203104',
      NULL,
      '43042443',
      '03400412',
      NULL,
      NULL,
      '40124033',
      '33102410',
      NULL,
      '11414003',
      '20141404',
      '22421034',
      '44423131',
      '14243103',
      NULL,
      '11111320',
      '14412423',
      '30123313',
      '13311100',
      NULL,
      '21213101',
      '12412430',
      '24220214',
      '21002140',
      '10231332',
      NULL,
      '34042142',
      '41433313',
      '02120033',
      '22112002',
      '20004324',
      '31102443',
      '01404001',
      NULL,
      '',
      NULL,
      NULL,
      '2040313',
      2,
      1.387805,
      0,
      NULL,
      NULL,
      1.360202,
      ' 6- 4-1980',
      '11-17-2003',
      36.449436,
      NULL,
      1.705560,
      NULL,
      9.240207,
      14.435113,
      NULL,
      16,
      5,
      7.293107,
      12.104689,
      NULL,
      27,
      16.922131,
      20.891597,
      11.407595,
      11,
      7,
      14,
      7.635321,
      24.679578,
      4,
      17.201056,
      3,
      NULL,
      98,
      10,
      8.404409,
      147,
      NULL,
      128.113318,
      ' 7-10-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.960369,
      6.164900,
      NULL,
      NULL,
      NULL,
      NULL,
      1.053726,
      1,
      2.619795,
      1.578401,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-11-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      50.079412,
      83.626093,
      42,
      65.570283,
      42,
      47,
      9.880799,
      96.782702,
      26.719306,
      NULL,
      26,
      ' 0- 2-2002',
      9.436160,
      1,
      1.415848,
      0,
      28.611782,
      NULL,
      1,
      ' 2- 8-2000',
      NULL,
      1.892665,
      ' 3- 0-1988',
      2.479722,
      11.552987,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      9.118868,
      NULL,
      22.745434,
      4.919172,
      1.712314,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 1-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36,
      32,
      2,
      ' 0-19-1996',
      3.162555,
      NULL,
      '10-29-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      25.719477,
      NULL,
      NULL,
      22.366112,
      NULL,
      0,
      NULL,
      13.437217,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.512825,
      3,
      1.630811,
      2.372206,
      NULL,
      1.472959,
      1.503267,
      2,
      NULL,
      ' 0-16-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-28-2003',
      NULL);
commit;
end;
/


