set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9427817';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0210',
      NULL,
      NULL,
      '14442432',
      '00421320',
      '34411240',
      '20242200',
      '32230424',
      NULL,
      '44241201',
      '00030424',
      '43302242',
      NULL,
      '32140411',
      NULL,
      '04413403',
      '32021431',
      '13112441',
      '33413400',
      '32112410',
      NULL,
      '10001330',
      NULL,
      NULL,
      '43223100',
      '14413413',
      NULL,
      '43144044',
      '32222441',
      '02221422',
      '12222442',
      '21042104',
      '24113430',
      NULL,
      '33124131',
      '14110240',
      '43340112',
      '30023014',
      '12141343',
      '03024344',
      '24220433',
      NULL,
      '30242113',
      '31302321',
      NULL,
      '321',
      '24',
      13,
      6,
      NULL,
      3.233128,
      1.675840,
      3,
      NULL,
      '341212',
      0.113476,
      '10-10-1997',
      '10-14-1989',
      55,
      86,
      45.790040,
      23.746406,
      NULL,
      0.588874,
      57,
      NULL,
      5.364440,
      16,
      27,
      NULL,
      37.053118,
      NULL,
      9.506394,
      NULL,
      28,
      1.294334,
      NULL,
      21.321897,
      12,
      NULL,
      35,
      18,
      0.532506,
      21,
      12.377381,
      106.681459,
      136,
      195.660273,
      63.415213,
      ' 9- 7-1996',
      1.125606,
      23.941025,
      24,
      26,
      102.199955,
      5,
      ' 7- 0-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      11,
      18,
      11,
      NULL,
      NULL,
      '11- 0-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      44.355807,
      97,
      48,
      68.222382,
      NULL,
      90,
      51.649448,
      71.550871,
      27,
      '10-14-1988',
      2.633503,
      17.727072,
      24.305779,
      77,
      10.729443,
      62.472895,
      7,
      ' 1- 5-1989',
      1.051482,
      1.005784,
      ' 6- 1-2003',
      9.442654,
      NULL,
      0,
      12,
      2.797640,
      0,
      2.027818,
      7,
      1.359808,
      17,
      14.447037,
      6.652070,
      1.328443,
      NULL,
      2.381432,
      0,
      0.930264,
      3,
      ' 9-13-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.193176,
      ' 8- 8-1979',
      NULL,
      NULL,
      NULL,
      14,
      '11-26-1998',
      42.325585,
      ' 5- 0-1999',
      NULL,
      NULL,
      NULL,
      54,
      11.778556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      ' 9- 5-1978',
      NULL,
      8.843780,
      19,
      ' 2-22-1988',
      NULL,
      85.254114,
      ' 9-18-1998',
      4,
      6.277957,
      NULL,
      59.459783,
      '11-28-2000',
      1,
      0.765032,
      25,
      ' 8- 0-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


