set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8734866';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4343',
      '30130222',
      '41434411',
      NULL,
      NULL,
      '24310312',
      '14324132',
      '21304422',
      '24323143',
      '11420311',
      '31300013',
      '13132313',
      NULL,
      '12224343',
      '24442433',
      '12444042',
      NULL,
      '22233012',
      NULL,
      '04110224',
      '44003403',
      NULL,
      '34114341',
      NULL,
      '44402123',
      '42122343',
      '30100033',
      NULL,
      '44310044',
      '11043132',
      '32123003',
      '21130330',
      '12001334',
      '42300043',
      '04234430',
      '22304411',
      '43034421',
      '10123010',
      '24414001',
      '44044112',
      '11223434',
      '13143333',
      '41412101',
      '32302044',
      '03012124',
      '430',
      '04',
      6.758216,
      4,
      NULL,
      NULL,
      1,
      0,
      NULL,
      '302344',
      0,
      NULL,
      NULL,
      69.862734,
      NULL,
      2,
      1.667352,
      9.139020,
      15.647889,
      56.054910,
      8.951215,
      9.994228,
      1,
      6,
      12.559260,
      3,
      12,
      10,
      NULL,
      4,
      5.858562,
      NULL,
      NULL,
      7.155161,
      NULL,
      54,
      3,
      0.334577,
      30.770136,
      62.012562,
      60.184241,
      63.426766,
      126,
      95,
      ' 2- 7-1997',
      16,
      32,
      19.802988,
      26.419931,
      9,
      NULL,
      ' 4-20-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17.616349,
      0,
      NULL,
      0,
      1.927528,
      NULL,
      2,
      1,
      93.420468,
      4,
      1.900174,
      NULL,
      0.026713,
      NULL,
      20,
      NULL,
      NULL,
      NULL,
      ' 6-20-1991',
      90,
      102.204288,
      NULL,
      85.709016,
      37.527852,
      79,
      60,
      9,
      36,
      7.308389,
      NULL,
      NULL,
      ' 8-18-2001',
      NULL,
      8,
      16,
      47,
      37,
      112.543130,
      7,
      ' 9- 9-1988',
      4,
      1,
      NULL,
      0,
      11,
      NULL,
      9.089288,
      1,
      NULL,
      1.794081,
      5,
      3,
      NULL,
      0,
      1,
      5.027660,
      NULL,
      0,
      11,
      9.421587,
      5,
      ' 8-11-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      31.680970,
      25,
      ' 2- 1-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 6-1990',
      2,
      NULL,
      ' 7- 3-2000',
      13.645357,
      NULL,
      ' 1- 2-1996',
      1,
      0,
      ' 7-22-1993',
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      ' 3-28-1978',
      NULL,
      34,
      30.848160,
      '11-11-2002',
      2,
      197,
      ' 5- 4-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


