set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908205';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4043',
      '04124432',
      NULL,
      '20023213',
      '44241110',
      '42111303',
      '02242032',
      '34014324',
      '44404212',
      '44102122',
      '11133131',
      '10214414',
      NULL,
      '33100211',
      '14441244',
      NULL,
      NULL,
      '24043012',
      '44204032',
      '34142103',
      NULL,
      '10042001',
      '43442021',
      '20223120',
      '44244110',
      '24142424',
      NULL,
      '01404001',
      '20001144',
      '02144331',
      '30133004',
      '12012012',
      '34404443',
      NULL,
      '21212403',
      NULL,
      '14010113',
      '33331304',
      '01311022',
      '31030121',
      '40230041',
      '33142002',
      '41112400',
      '31104433',
      '23323430',
      '',
      '',
      NULL,
      NULL,
      '4043201',
      2.662819,
      1,
      NULL,
      NULL,
      '400334',
      NULL,
      ' 8- 4-1976',
      ' 2-29-1993',
      29,
      NULL,
      25,
      15.745102,
      22,
      10,
      72.507015,
      1,
      2,
      2,
      20.614947,
      8,
      13.966529,
      15,
      11,
      4.572196,
      14,
      9,
      33,
      12.046657,
      52.672214,
      NULL,
      58,
      13,
      NULL,
      86.020435,
      169.601245,
      43,
      15.770368,
      4.287407,
      164.947421,
      ' 3- 2-2003',
      22.456749,
      39.433215,
      21.496938,
      23.058017,
      NULL,
      212.271298,
      NULL,
      1.995148,
      0.746817,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.041924,
      1.590787,
      1.159886,
      NULL,
      0.241369,
      1.112046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-19-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      135,
      NULL,
      42.905860,
      46.565807,
      17.724040,
      NULL,
      3.491915,
      NULL,
      38.370867,
      39.076697,
      37,
      74.811843,
      ' 6-17-1984',
      18,
      11,
      16,
      1.906010,
      49.938248,
      51.142479,
      1,
      ' 0-15-2000',
      2,
      NULL,
      ' 5-18-2000',
      11,
      11,
      3,
      10,
      4,
      7,
      NULL,
      4,
      NULL,
      16.129451,
      NULL,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-17-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24,
      1,
      NULL,
      ' 4-11-1989',
      3,
      NULL,
      ' 7-12-1999',
      NULL,
      43.851006,
      2,
      14,
      ' 8- 6-2001',
      NULL,
      0.140155,
      155.718297,
      ' 3-21-1987',
      NULL,
      NULL,
      NULL,
      49,
      0.630046,
      8,
      68.761903,
      7.543761,
      121,
      NULL,
      17,
      63.944651,
      31.476992,
      6.710902,
      NULL,
      1.667774,
      NULL,
      NULL,
      NULL,
      0.900474,
      45.203696,
      0,
      1,
      198.261147,
      NULL,
      2,
      271.583515,
      49,
      13,
      54,
      1,
      NULL,
      NULL,
      1,
      0.553530,
      1.461954,
      0.828096,
      0,
      36,
      70.176361,
      42.562689,
      11.615918,
      67,
      NULL,
      1.886740,
      1.496001,
      9,
      NULL,
      NULL,
      0,
      NULL,
      1.855555,
      NULL,
      1,
      40.985267,
      3.589519,
      0.538898,
      5.859517,
      NULL,
      8.558346,
      21.812530,
      36.705351,
      NULL,
      NULL,
      50,
      10,
      2,
      NULL,
      4,
      0,
      1,
      NULL,
      0,
      69,
      ' 5- 1-1982',
      NULL,
      '10-22-1981',
      ' 1- 4-1982',
      ' 3-25-1992',
      ' 2-27-1984',
      '11-29-1986',
      NULL);
commit;
end;
/


