set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908205';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2440',
      '12132430',
      '20301232',
      NULL,
      '00240421',
      '20032410',
      '22343321',
      '42013114',
      '31121010',
      '10301403',
      '12433010',
      '03144224',
      '40131131',
      '31410440',
      '43331332',
      '30221111',
      '13401300',
      '23420002',
      '23020034',
      NULL,
      '00203114',
      '24242030',
      '13221442',
      '02323122',
      '11141311',
      '41042100',
      '04334440',
      '44224033',
      '14213120',
      NULL,
      '43122330',
      '04142011',
      NULL,
      '33334433',
      '30441412',
      '44304022',
      '14200221',
      NULL,
      '02101230',
      '24322220',
      '21132334',
      '32331013',
      '10310223',
      '33123001',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      0.998335,
      9,
      NULL,
      NULL,
      '101103',
      NULL,
      ' 0- 3-1996',
      ' 5- 8-1993',
      51,
      NULL,
      NULL,
      NULL,
      14.866340,
      11,
      21,
      NULL,
      1.892655,
      7.453269,
      11,
      0,
      20,
      NULL,
      9,
      12,
      23.207625,
      4,
      6,
      0,
      45.287660,
      21.158659,
      20.861132,
      12,
      NULL,
      16,
      150.770825,
      NULL,
      19.923827,
      168.621384,
      40,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 6-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.637118,
      NULL,
      83.006331,
      53.442503,
      88,
      8.885232,
      ' 0- 3-2001',
      NULL,
      NULL,
      '11-11-1974',
      8.062757,
      NULL,
      11.345026,
      11.852495,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      3.696583,
      7.257414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 3-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.508056,
      27,
      ' 5- 3-2002',
      1,
      NULL,
      '10-17-1978',
      9.500794,
      5.257690,
      9.719461,
      20.327403,
      ' 4- 5-1988',
      58.601495,
      1.230183,
      120,
      ' 7- 7-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      37,
      35,
      NULL,
      NULL,
      12,
      NULL,
      6.449658,
      46.966050,
      0.731949,
      0,
      67.076697,
      0.519356,
      1.389881,
      NULL,
      1.317052,
      NULL,
      77,
      NULL,
      1,
      162,
      38,
      NULL,
      NULL,
      1,
      0.897041,
      0.775279,
      NULL,
      1,
      0,
      NULL,
      0,
      43,
      NULL,
      NULL,
      NULL,
      NULL,
      20.483985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.205094,
      14.753348,
      NULL,
      2.164216,
      45.081701,
      24.293603,
      NULL,
      27,
      44,
      16.657658,
      NULL,
      NULL,
      8.000363,
      9.215033,
      3,
      NULL,
      3.739087,
      0,
      0,
      0.433791,
      56.989979,
      ' 1- 8-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-15-1982',
      NULL);
commit;
end;
/


