set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702771';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '31104423',
      '03401324',
      '11404431',
      '22243314',
      '30004200',
      '43433220',
      '30211423',
      '40124213',
      '02331404',
      NULL,
      '41424443',
      '02331302',
      NULL,
      '31040433',
      NULL,
      '03021221',
      '41130411',
      '22321423',
      '01004223',
      '44142331',
      '32314301',
      '10330213',
      '11230231',
      NULL,
      '41440332',
      '01421234',
      NULL,
      '24011243',
      '03413100',
      '00240411',
      NULL,
      '20432420',
      '30114401',
      NULL,
      '14311232',
      '33223032',
      '31013323',
      NULL,
      '00330131',
      '04401021',
      '24410210',
      '21244442',
      '11002144',
      '01430414',
      '002',
      '30',
      NULL,
      10.343631,
      '4003204',
      2.579012,
      0.100071,
      2,
      NULL,
      '102112',
      NULL,
      NULL,
      '11-12-1992',
      41.371874,
      106,
      NULL,
      6,
      30,
      15.532146,
      NULL,
      9,
      2.819106,
      NULL,
      36.756789,
      2.547847,
      34,
      10,
      9.196332,
      5.409035,
      7,
      1.175352,
      44.157886,
      16,
      NULL,
      3.205879,
      97,
      NULL,
      1.396332,
      110,
      182,
      27.047411,
      5.323007,
      41,
      42,
      ' 8- 8-1994',
      16,
      59,
      22,
      37,
      NULL,
      146.428057,
      ' 6-24-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.027587,
      20.902917,
      10.840845,
      29,
      6,
      0,
      ' 2-11-1992',
      0.200395,
      2.446966,
      62.750431,
      0.885274,
      4.221896,
      77,
      0.578113,
      3,
      26,
      NULL,
      NULL,
      NULL,
      NULL,
      53.235022,
      36,
      21.482799,
      51.529521,
      58.639378,
      NULL,
      55,
      0.553212,
      77.720843,
      25,
      72,
      42.514579,
      ' 6-22-1979',
      5.218977,
      29,
      3.123790,
      90.306712,
      115,
      189,
      10.498049,
      NULL,
      16,
      1.674097,
      ' 7-21-1990',
      NULL,
      0,
      12.071020,
      5.635116,
      12.675760,
      11,
      0.644043,
      6,
      1.087646,
      5,
      1,
      13,
      17,
      19,
      0,
      0,
      1,
      1,
      ' 4-23-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      112,
      24,
      '11- 7-1992',
      NULL,
      NULL,
      NULL,
      30.129388,
      ' 4-23-1986',
      24.103743,
      NULL,
      6.583995,
      10,
      '11-22-1994',
      91.847452,
      50.487931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      13,
      NULL,
      1.868626,
      41,
      NULL,
      ' 9-17-2001',
      NULL,
      81.029187,
      ' 6-25-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


