set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6403615';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3343',
      '00143444',
      '01242331',
      '34424420',
      NULL,
      NULL,
      '14444434',
      '00301324',
      '23401221',
      '24332032',
      '34134322',
      '00210004',
      '43134434',
      NULL,
      '24204020',
      '00212020',
      '21030322',
      '40221012',
      '44004223',
      '14000041',
      '10443111',
      '3',
      '2',
      '4',
      '20320341',
      '1',
      '24240433',
      NULL,
      '10241104',
      '4',
      '2',
      '1',
      '40302102',
      '13120400',
      '3',
      '3',
      '3',
      '1',
      '2',
      '1',
      '42402113',
      '02131423',
      '23233104',
      '00424414',
      '21214100',
      NULL,
      '14',
      13.919210,
      5,
      '1322310',
      2,
      1.831182,
      1,
      NULL,
      '102011',
      1.246177,
      ' 5-26-1999',
      '10-13-1975',
      NULL,
      39,
      14.039809,
      5,
      3,
      0.273249,
      11.071218,
      13.257050,
      NULL,
      4.063469,
      11,
      NULL,
      13,
      NULL,
      14,
      0,
      0.274235,
      11,
      18,
      NULL,
      NULL,
      18.938208,
      NULL,
      2,
      NULL,
      85,
      NULL,
      29.375776,
      28.634145,
      29,
      108,
      '11-25-1998',
      17.590881,
      6,
      3,
      NULL,
      34.351240,
      NULL,
      ' 7-17-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      56.930925,
      51,
      NULL,
      13,
      13.624348,
      5.013741,
      ' 9-17-1986',
      0,
      1,
      119.932885,
      1,
      1.223102,
      NULL,
      0,
      9.292756,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      47.769481,
      29,
      20.124261,
      NULL,
      55,
      NULL,
      NULL,
      48.889591,
      NULL,
      6.656921,
      23.364168,
      37.439401,
      ' 0- 0-1976',
      3,
      1.936134,
      12.631457,
      75,
      68.006422,
      39.215429,
      8.657496,
      ' 5-21-1985',
      10,
      8,
      ' 4-23-1990',
      1,
      4.428949,
      8.310907,
      6.422335,
      3.392473,
      7,
      3,
      7.182634,
      0,
      0.694583,
      3,
      0.211769,
      1.298461,
      4,
      NULL,
      NULL,
      0.692966,
      NULL,
      ' 2-15-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.225720,
      ' 8- 6-1987',
      NULL,
      NULL,
      NULL,
      44.245444,
      ' 2- 5-1974',
      NULL,
      NULL,
      0.759386,
      11.635094,
      NULL,
      0.804888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      17,
      NULL,
      4.233151,
      23.791774,
      10,
      '11-13-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      122.131075,
      ' 2-29-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


