set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8808017';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1412',
      '23113213',
      '13344141',
      '30303321',
      '33100440',
      '14312311',
      '13031012',
      '44420433',
      NULL,
      NULL,
      '03321131',
      '23201223',
      NULL,
      '44004431',
      NULL,
      '00312143',
      NULL,
      '01214122',
      NULL,
      NULL,
      NULL,
      '03020122',
      '11000004',
      NULL,
      '03113023',
      '21244343',
      '32030312',
      NULL,
      NULL,
      '40344414',
      '34310320',
      '20300000',
      '01320324',
      '34413324',
      '01121022',
      '02313200',
      '03423241',
      '32412023',
      '44214202',
      '40110221',
      '11330320',
      '24022043',
      '32321140',
      '30324304',
      '01242200',
      NULL,
      '',
      NULL,
      NULL,
      '2010242',
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      ' 7- 1-2003',
      ' 6- 2-2001',
      54.565410,
      NULL,
      NULL,
      7,
      21,
      1.032121,
      5.697846,
      19,
      8.543491,
      24.711915,
      4,
      10.093294,
      15.944024,
      NULL,
      24.986670,
      4.323661,
      21.116638,
      22,
      44,
      NULL,
      40,
      6,
      157,
      3.217272,
      NULL,
      19,
      49.162176,
      2,
      NULL,
      112.748734,
      136.759086,
      ' 6-29-1977',
      1,
      32,
      15,
      6,
      NULL,
      164.682981,
      ' 3-21-1993',
      0.731833,
      0,
      1,
      1.542714,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.210345,
      0,
      1.592368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 8-1991',
      47,
      37.650686,
      13.208070,
      NULL,
      8.314684,
      0.819228,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-24-1991',
      NULL,
      NULL,
      76,
      99.647958,
      98,
      136.994579,
      80,
      22,
      69.332889,
      70.566480,
      90.547700,
      108.200913,
      ' 2-21-1983',
      2,
      9,
      NULL,
      NULL,
      6,
      46.306608,
      11.768802,
      ' 0-29-1976',
      33.640597,
      10,
      ' 7-23-1983',
      NULL,
      10.497493,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      10,
      NULL,
      NULL,
      10.598220,
      NULL,
      29,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-11-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      45,
      17,
      56,
      ' 6- 2-1996',
      NULL,
      NULL,
      ' 7-20-1984',
      12.545730,
      24.684773,
      0,
      NULL,
      '11-28-1975',
      3.896793,
      4,
      6,
      ' 0-18-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      1.661615,
      1.668422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.393010,
      0,
      NULL,
      0.087214,
      1.269650,
      NULL,
      1,
      1,
      12.620982,
      0,
      NULL,
      114,
      NULL,
      3,
      NULL,
      1.590962,
      NULL,
      1,
      0,
      1.081129,
      5,
      1,
      1.855114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.021898,
      1,
      0.411562,
      7.840070,
      5.455881,
      16,
      2,
      NULL,
      1.485740,
      NULL,
      0.197782,
      1.437251,
      NULL,
      17.607815,
      11.520783,
      21.572942,
      NULL,
      NULL,
      25.440756,
      NULL,
      NULL,
      2.146639,
      0,
      NULL,
      NULL,
      1.555999,
      NULL,
      0,
      NULL,
      NULL,
      '11-17-1995',
      ' 2- 9-1995',
      ' 1- 2-1981',
      ' 8-15-1989',
      NULL,
      '11- 4-1997',
      NULL);
commit;
end;
/


