set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7738689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      NULL,
      '1',
      NULL,
      NULL,
      '0',
      '0',
      '3',
      '3',
      '4',
      '2',
      '1',
      '3',
      '3',
      '0',
      '0',
      '3',
      '2',
      '0',
      '2',
      '4',
      NULL,
      '2',
      '',
      '0',
      '',
      '0',
      '2',
      '2',
      NULL,
      '0',
      '',
      '',
      '2',
      NULL,
      NULL,
      '4',
      '3',
      '0',
      '3',
      '0',
      '0',
      '3',
      NULL,
      '000',
      NULL,
      NULL,
      43.388534,
      '2041343',
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 6-1979',
      254,
      NULL,
      18,
      21,
      34.811344,
      20,
      20.582213,
      25,
      NULL,
      23.167670,
      27,
      18.451375,
      45,
      12,
      7,
      8,
      12.707466,
      NULL,
      64.839686,
      NULL,
      26,
      3,
      74.830960,
      11,
      1,
      NULL,
      175,
      50,
      13.167515,
      54.700470,
      149,
      NULL,
      43,
      55.445389,
      29.371083,
      NULL,
      178.493914,
      215.996459,
      ' 3-14-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2,
      0,
      ' 5- 4-1978',
      1,
      NULL,
      NULL,
      0.843173,
      2,
      90.980459,
      0.585404,
      0.060108,
      44.594536,
      NULL,
      NULL,
      NULL,
      ' 4- 6-1981',
      49.813618,
      NULL,
      16.482812,
      NULL,
      48,
      90.141161,
      48.581560,
      4.625456,
      83.489363,
      82.700271,
      81,
      40,
      NULL,
      26,
      NULL,
      NULL,
      75,
      76.329130,
      66,
      0.050592,
      ' 6- 0-1983',
      5,
      17,
      ' 4- 6-1986',
      16.851431,
      9,
      1,
      15.745796,
      23.220353,
      NULL,
      0.326849,
      16.870969,
      0.374038,
      93,
      0.573292,
      3.921827,
      24.115082,
      0.932854,
      1,
      1,
      0.866530,
      1.942450,
      ' 5-19-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 4-17-1994',
      NULL,
      NULL,
      NULL,
      0.528674,
      ' 4-21-1978',
      50,
      ' 0-17-1974',
      NULL,
      3.061068,
      ' 2-14-2003',
      41,
      107.529831,
      ' 2- 6-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.951411,
      '10-21-1984',
      13.323378,
      1,
      36,
      ' 9- 6-1998',
      NULL,
      44.593190,
      ' 7-22-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


