set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9514251';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1200',
      NULL,
      '33130211',
      '34123242',
      '41440334',
      '40400330',
      NULL,
      '13432113',
      NULL,
      NULL,
      '23123033',
      NULL,
      '20201112',
      '41401422',
      '00333111',
      '43333222',
      '30313122',
      '12440311',
      '24230434',
      '42141124',
      '24221401',
      '34231244',
      '44044330',
      '34304032',
      '21132421',
      '23041414',
      NULL,
      '23211340',
      '23402011',
      '13412320',
      NULL,
      '24243122',
      '32024221',
      '33232131',
      '44401024',
      '31324142',
      '03433124',
      '32202401',
      '42332301',
      NULL,
      NULL,
      '30444231',
      NULL,
      '14110321',
      '14404101',
      NULL,
      '40',
      NULL,
      NULL,
      '1311304',
      NULL,
      NULL,
      0,
      NULL,
      '141000',
      1,
      '11-28-1988',
      ' 4-23-1994',
      101.171503,
      NULL,
      19,
      11,
      5,
      15,
      39,
      5,
      6.584322,
      9.730392,
      18,
      3,
      12.987653,
      16.047947,
      NULL,
      NULL,
      4,
      10.587314,
      8,
      5,
      18.232422,
      8.114987,
      41.149611,
      3,
      1.331000,
      55.293827,
      NULL,
      17,
      30.537761,
      104.164600,
      148,
      ' 8-12-1983',
      47,
      4,
      29,
      NULL,
      131,
      45,
      ' 1-26-2000',
      15,
      26,
      9.989861,
      15.971333,
      11,
      0,
      7.943463,
      15,
      NULL,
      0,
      16,
      1,
      1,
      NULL,
      1.821830,
      0.955651,
      7.185614,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-17-1994',
      29,
      36,
      12.412108,
      0,
      33,
      1.265324,
      ' 0- 0-1980',
      3,
      NULL,
      32.954275,
      NULL,
      1.353140,
      38,
      0.814555,
      1,
      75,
      NULL,
      NULL,
      NULL,
      ' 7-27-1977',
      29,
      NULL,
      22.364043,
      66.389588,
      7,
      28,
      49,
      35.797170,
      24.381837,
      24,
      14,
      71.690683,
      ' 8- 8-1978',
      23.903626,
      0,
      4.123199,
      51,
      29.806152,
      45,
      2,
      ' 3- 3-1992',
      0,
      7,
      NULL,
      10.175633,
      9,
      0.477146,
      NULL,
      0.267591,
      6,
      0,
      NULL,
      NULL,
      77.412449,
      1,
      3.831867,
      5.878388,
      12,
      8,
      NULL,
      2.637276,
      1,
      ' 7-23-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      72.243511,
      39.424268,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      ' 8-22-1989',
      NULL,
      NULL,
      NULL,
      4,
      ' 2-16-1979',
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      ' 0-20-1992',
      NULL,
      NULL,
      NULL,
      2,
      1,
      11,
      ' 8-11-1975',
      44,
      18.032685,
      14,
      ' 5-13-2000',
      6.062444,
      59.195682,
      ' 1- 4-1977',
      6,
      53.234465,
      4.094506,
      51,
      NULL,
      10,
      1.762283,
      165,
      ' 0-28-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


