set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9514251';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '1',
      '2',
      '4',
      NULL,
      '2',
      '0',
      '4',
      NULL,
      '4',
      '0',
      '0',
      NULL,
      '2',
      '2',
      '3',
      '1',
      '3',
      '0',
      '2',
      '4',
      '2',
      '0',
      '2',
      NULL,
      '4',
      '',
      '4',
      '0',
      NULL,
      '2',
      '3',
      '',
      '',
      '2',
      '1',
      '0',
      '0',
      '2',
      '0',
      '2',
      '0',
      '2',
      '1',
      '0',
      NULL,
      '12023014',
      23.333178,
      35,
      '3332044',
      2,
      36,
      2,
      NULL,
      '433003',
      1,
      ' 2-11-1989',
      NULL,
      29.844312,
      246,
      27.731596,
      10,
      NULL,
      9,
      44,
      12,
      7.780843,
      2,
      32,
      8.377511,
      36.752030,
      17.315165,
      NULL,
      8,
      0.582474,
      NULL,
      63,
      17.421186,
      56,
      0.560584,
      68,
      8.581941,
      NULL,
      90,
      NULL,
      63.810226,
      19,
      122,
      NULL,
      ' 4-14-1985',
      33,
      2,
      12,
      21.168490,
      142.422110,
      59,
      ' 6-15-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39.574297,
      12,
      25.453037,
      8.046209,
      3.850779,
      NULL,
      0,
      1.904006,
      98,
      1.645360,
      NULL,
      6,
      0,
      1.852635,
      32.886313,
      NULL,
      NULL,
      NULL,
      ' 2-20-1975',
      79.629791,
      33.173935,
      12.896085,
      95,
      82.587105,
      72,
      80,
      NULL,
      NULL,
      56.473041,
      87.104070,
      92.813993,
      ' 0-21-2002',
      25.922264,
      1.428095,
      18,
      43,
      13,
      15.405776,
      4.851874,
      ' 4-10-1985',
      1,
      17,
      ' 7- 3-1990',
      NULL,
      6,
      NULL,
      9,
      4.703583,
      6,
      0,
      5.754970,
      1.166800,
      5.726643,
      5.542356,
      NULL,
      4,
      22.613966,
      0,
      0,
      NULL,
      0,
      ' 6-17-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36.044195,
      NULL,
      6.150661,
      '11-29-1996',
      10,
      NULL,
      ' 9-19-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      ' 0-15-1986',
      65,
      19.460220,
      NULL,
      ' 0- 0-1990',
      1,
      113.060067,
      ' 4-19-2003',
      1.756332,
      8,
      9,
      22,
      ' 6-27-1979',
      39,
      NULL,
      119.116011,
      ' 8- 8-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


