set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9514251';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      '3',
      '2',
      '2',
      '1',
      '1',
      '4',
      NULL,
      '4',
      '0',
      '0',
      '0',
      '4',
      NULL,
      '2',
      '1',
      '1',
      NULL,
      '1',
      '0',
      NULL,
      '4',
      '4',
      '',
      '2',
      '',
      '1',
      '4',
      '3',
      '1',
      NULL,
      NULL,
      '',
      '2',
      '2',
      '2',
      '0',
      '3',
      '0',
      '0',
      '1',
      '1',
      NULL,
      '2',
      '240',
      '33244033',
      11,
      46.111890,
      '0102434',
      2.283611,
      173.885141,
      3,
      1,
      '120023',
      1.316931,
      ' 7-22-1977',
      ' 8-27-1976',
      80,
      35,
      1,
      17,
      NULL,
      1.465576,
      NULL,
      12.101808,
      18.638492,
      NULL,
      2.202800,
      10.794175,
      NULL,
      14,
      23.052009,
      0.667532,
      2,
      14.158242,
      20.268407,
      5.711013,
      40,
      13,
      74.007104,
      0,
      0,
      NULL,
      80,
      71,
      36.191811,
      60,
      148,
      ' 2-26-1989',
      28,
      NULL,
      14.460065,
      7,
      1.973025,
      152.784548,
      ' 6-16-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22.504450,
      49.999407,
      35,
      NULL,
      7,
      3,
      '10-24-1987',
      0.499592,
      NULL,
      104,
      NULL,
      1,
      NULL,
      0.479202,
      NULL,
      53,
      NULL,
      NULL,
      NULL,
      NULL,
      0.018199,
      5,
      84,
      44,
      57,
      7.275423,
      48,
      NULL,
      46,
      NULL,
      70,
      60,
      ' 8-18-1996',
      15,
      4,
      2,
      3.888596,
      44,
      87.018888,
      3.119224,
      ' 6-12-1988',
      19,
      12,
      ' 4-20-2001',
      10.087900,
      5,
      2,
      5.685615,
      0.621100,
      0,
      NULL,
      4.089478,
      1.261458,
      NULL,
      0,
      0,
      NULL,
      16,
      4.940224,
      4,
      0,
      NULL,
      ' 7-24-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40.601518,
      ' 2- 4-1981',
      14.354405,
      ' 3-12-1994',
      13.209205,
      5.280233,
      ' 5- 4-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7,
      '10-26-1988',
      60.438077,
      4.617293,
      21,
      NULL,
      1.416226,
      40.712281,
      NULL,
      10.198500,
      14,
      10.107632,
      4.760409,
      NULL,
      63.317582,
      0.145489,
      NULL,
      ' 8- 4-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


