set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9235780';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2112',
      '24314142',
      '23120244',
      '12212144',
      '44310002',
      '31233243',
      '04134013',
      '01113213',
      '02233303',
      '13313312',
      '44004301',
      '14244124',
      '01204330',
      '32042131',
      '00304020',
      '43034220',
      '03042434',
      '41413323',
      '33340444',
      '03433021',
      '21330440',
      '11323011',
      NULL,
      '33131032',
      '34211422',
      '30320431',
      '41100331',
      '41334423',
      NULL,
      '31033244',
      '42142140',
      '10040034',
      NULL,
      '31212343',
      '43440410',
      '24302414',
      NULL,
      '30114213',
      '31311242',
      '44133341',
      '34300321',
      '34420420',
      NULL,
      '04020343',
      '30121401',
      '424',
      NULL,
      NULL,
      NULL,
      '1443412',
      0.739048,
      1.444030,
      NULL,
      NULL,
      '122434',
      2,
      '11-14-1992',
      ' 2-25-2000',
      0,
      NULL,
      NULL,
      NULL,
      9,
      2.548572,
      NULL,
      11,
      NULL,
      16,
      34.157100,
      9.381370,
      16.580118,
      23.179514,
      15,
      14,
      NULL,
      NULL,
      99,
      25,
      8.781800,
      19.464170,
      102,
      3,
      0,
      54.172885,
      50,
      8,
      NULL,
      33,
      82,
      NULL,
      32.722651,
      22.094846,
      23,
      30.832250,
      NULL,
      176,
      ' 5- 3-1985',
      0,
      1,
      3,
      NULL,
      0.735761,
      1,
      NULL,
      1.133456,
      1.554026,
      1,
      1,
      NULL,
      NULL,
      1.501657,
      1,
      0.719762,
      1.066031,
      0.946728,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-27-1986',
      54,
      0.870009,
      1.007736,
      NULL,
      0,
      0.546414,
      ' 9-26-1984',
      0,
      NULL,
      64,
      0,
      NULL,
      98.449874,
      0.897352,
      1,
      51,
      1,
      2,
      139.082706,
      ' 0- 8-1992',
      28,
      NULL,
      17.885236,
      NULL,
      NULL,
      NULL,
      114,
      19,
      85,
      30,
      37,
      NULL,
      NULL,
      27,
      19,
      19.095942,
      61.641018,
      NULL,
      87,
      2,
      ' 0-23-2001',
      5,
      16.403039,
      ' 3-23-1998',
      5,
      12.203496,
      NULL,
      19,
      15.009173,
      6,
      1.876418,
      3.932817,
      NULL,
      91,
      0,
      1.144859,
      17,
      9,
      0.496306,
      1,
      0.627327,
      1,
      '11-29-1987',
      NULL,
      3.309167,
      NULL,
      ' 3- 6-1992',
      21,
      NULL,
      '11-12-1981',
      2.277345,
      NULL,
      ' 4- 5-1976',
      11,
      ' 4-24-1976',
      NULL,
      ' 8- 8-2003',
      5,
      7.209911,
      ' 5-25-1998',
      40,
      55.709693,
      ' 7-19-1996',
      4.605793,
      5.569782,
      ' 7- 3-1991',
      0.649211,
      12,
      ' 0-29-1991',
      2,
      1,
      15,
      NULL,
      36,
      NULL,
      NULL,
      '11-28-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


