set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9036326';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3220',
      '31221440',
      '21421343',
      '43410141',
      NULL,
      NULL,
      '21410444',
      '43101423',
      '34013422',
      '40204000',
      '42404204',
      '44333433',
      '04232343',
      '11410023',
      '44002100',
      NULL,
      '41414041',
      '42114120',
      '23113001',
      '23332021',
      NULL,
      NULL,
      NULL,
      '44020301',
      '11102142',
      '40414204',
      '02144243',
      '04203401',
      NULL,
      '31121244',
      '22443440',
      '34233000',
      '24002333',
      '31224402',
      '42014112',
      '22023314',
      '31221002',
      '34414202',
      '34111101',
      NULL,
      '22140324',
      '00013421',
      '30410034',
      '04234434',
      '41421420',
      NULL,
      '31',
      NULL,
      NULL,
      '2413243',
      2,
      1,
      3,
      NULL,
      '334430',
      5.264741,
      ' 3- 0-1981',
      NULL,
      20,
      NULL,
      6.275727,
      19.529478,
      5,
      22.678652,
      NULL,
      1,
      0.484775,
      15.054084,
      18,
      4,
      33.675561,
      14,
      NULL,
      7,
      2,
      5,
      8.709322,
      19,
      13,
      2,
      NULL,
      11.880100,
      1.871530,
      0,
      40,
      9,
      NULL,
      146,
      36,
      ' 3-22-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.556825,
      0,
      3.694397,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 3-1985',
      35.242505,
      72.971106,
      106.010196,
      87,
      140,
      9,
      18,
      10,
      51.589075,
      104.333280,
      10,
      55,
      ' 7-29-1982',
      NULL,
      27,
      39,
      56,
      70,
      NULL,
      9.024040,
      '10-22-1978',
      13.959347,
      6,
      NULL,
      14,
      1,
      3,
      7.400251,
      17,
      7,
      NULL,
      10,
      NULL,
      60.761042,
      1.610595,
      12.670648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 2-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      47,
      24,
      NULL,
      '10- 4-1983',
      0.421053,
      10,
      ' 0-26-1980',
      11.686204,
      10,
      21,
      39.136054,
      ' 4-20-1990',
      40,
      1,
      NULL,
      ' 4-28-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      150.486901,
      37,
      7,
      6,
      NULL,
      8.640221,
      NULL,
      1,
      1.183555,
      19,
      NULL,
      NULL,
      NULL,
      0.895388,
      1.478265,
      139.855143,
      4.980387,
      NULL,
      244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.661296,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      9,
      NULL,
      NULL,
      2.803158,
      3.040332,
      0,
      1.778721,
      NULL,
      ' 1- 2-1981',
      NULL,
      ' 5-17-1980',
      NULL,
      ' 1- 7-1993',
      NULL,
      NULL,
      NULL);
commit;
end;
/


