set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7403992';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2000',
      '24020000',
      '30433434',
      '23440410',
      '44333324',
      '23403341',
      NULL,
      NULL,
      '21301444',
      '12124214',
      '03234130',
      '10042441',
      '24312121',
      '10310223',
      NULL,
      '44340111',
      '14212424',
      '32331111',
      '31310441',
      NULL,
      NULL,
      '33130214',
      NULL,
      '33030120',
      NULL,
      NULL,
      '20442224',
      '01230440',
      '44403244',
      '23441421',
      '04110111',
      '42420103',
      NULL,
      '21121211',
      '20020023',
      '44211244',
      '11334441',
      NULL,
      '01003332',
      '30410114',
      '22441432',
      '30002041',
      '02412440',
      '21203142',
      '21042244',
      '134',
      '00',
      NULL,
      NULL,
      '0224342',
      0,
      NULL,
      2,
      NULL,
      '432400',
      NULL,
      ' 2-28-1995',
      ' 5-28-1982',
      117,
      NULL,
      NULL,
      6,
      NULL,
      4.694072,
      32,
      0,
      9,
      0.494940,
      16,
      1.134137,
      5.693294,
      12.532680,
      NULL,
      8.361120,
      NULL,
      0,
      39,
      NULL,
      58.505998,
      3.389911,
      NULL,
      11,
      NULL,
      17.569598,
      NULL,
      68,
      125,
      30.054008,
      142,
      ' 9- 4-1980',
      NULL,
      3.540796,
      6,
      21,
      NULL,
      NULL,
      NULL,
      NULL,
      0.687950,
      7.560930,
      1.880831,
      0,
      0.713822,
      4,
      3,
      0,
      0.684917,
      3.122722,
      1.325088,
      NULL,
      0.830324,
      1,
      1.143233,
      NULL,
      NULL,
      1.655865,
      0.539596,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-15-1994',
      9.456005,
      37.649038,
      0,
      8,
      15.090260,
      7,
      ' 4-19-1990',
      1,
      1.590905,
      80.682869,
      1,
      1,
      22.974083,
      1.641741,
      0.791416,
      5,
      1.460337,
      1,
      46.455803,
      '10-17-1976',
      0,
      17,
      7,
      19.901261,
      54.138410,
      47.744423,
      70,
      0.399123,
      38.127529,
      37.584889,
      39,
      35,
      '10- 4-1991',
      4,
      11.379940,
      11.459240,
      37.520153,
      NULL,
      10.477029,
      0.252592,
      NULL,
      3.053618,
      NULL,
      NULL,
      0,
      NULL,
      5,
      11.161724,
      6,
      6.102387,
      0.436783,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.779816,
      NULL,
      1,
      7,
      4.133591,
      10.796206,
      ' 3-17-2003',
      1,
      0.357457,
      3.099828,
      ' 2-17-2003',
      71,
      8,
      ' 9-24-2000',
      NULL,
      NULL,
      NULL,
      16,
      ' 4-15-1979',
      13.240258,
      ' 7- 4-1981',
      1.676067,
      4,
      ' 6-23-1988',
      20.100811,
      35,
      ' 3-10-1988',
      0.509617,
      9.943388,
      '10- 5-1993',
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.935988,
      ' 9-14-1986',
      25,
      26,
      33,
      ' 6- 7-1994',
      7,
      10.153919,
      ' 7-21-1988',
      NULL,
      181,
      12.415850,
      143,
      NULL,
      52.166911,
      2,
      13.451323,
      '10-11-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.243285);
commit;
end;
/


