set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7403992';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2330',
      '24234431',
      '04031410',
      NULL,
      '01040032',
      '42421021',
      NULL,
      '41421141',
      '14244133',
      '20130124',
      '14434431',
      '30443400',
      NULL,
      '42213341',
      '00012041',
      NULL,
      '33042244',
      NULL,
      '43300433',
      '21134420',
      NULL,
      '11422422',
      NULL,
      '31342010',
      '34323230',
      '04420203',
      '12013120',
      '04123311',
      NULL,
      '32111410',
      '23431401',
      '13104422',
      '04323213',
      '30001301',
      NULL,
      '22430342',
      '21221243',
      '34323101',
      '24331022',
      '24023442',
      '10131131',
      '23430443',
      '01320031',
      '31144100',
      '42140041',
      '324',
      '24',
      NULL,
      NULL,
      '0020041',
      3,
      15.251187,
      0,
      NULL,
      NULL,
      NULL,
      ' 2-12-2003',
      ' 9-13-1982',
      113.659442,
      NULL,
      5.324241,
      0.776621,
      NULL,
      11.146532,
      20.196302,
      15.802161,
      11,
      10.466854,
      16,
      5.901191,
      21.601272,
      15,
      24,
      10.539282,
      14.743406,
      6.053297,
      18,
      0,
      46,
      13,
      NULL,
      NULL,
      0.349294,
      78,
      143,
      63.252050,
      30,
      131,
      101.429082,
      ' 6- 7-1996',
      13,
      2,
      NULL,
      10,
      67.035772,
      NULL,
      ' 0- 9-1988',
      0,
      1.617600,
      3,
      1.498291,
      NULL,
      1,
      1.005530,
      1,
      1.888936,
      0.652838,
      NULL,
      1,
      NULL,
      1.848438,
      0.853569,
      0.771987,
      0,
      0,
      1,
      1.584727,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-18-1974',
      66,
      10.166643,
      11.209975,
      NULL,
      9,
      4.823839,
      '11-22-1998',
      0,
      1,
      0.854499,
      1.326648,
      1.090949,
      24.762072,
      0.965051,
      5,
      50.159889,
      NULL,
      NULL,
      NULL,
      ' 2-26-1976',
      23,
      54.017930,
      39.126661,
      65.206379,
      42.047028,
      NULL,
      NULL,
      12.962546,
      55,
      22,
      0.919395,
      11.996050,
      ' 2-27-1986',
      NULL,
      4,
      NULL,
      29,
      55.510974,
      44,
      NULL,
      ' 4-17-1997',
      4,
      NULL,
      NULL,
      2.232974,
      NULL,
      2.135319,
      5,
      7.830917,
      1.865984,
      0,
      12,
      1,
      43,
      0,
      NULL,
      1.785353,
      NULL,
      0.508059,
      4,
      1,
      0.762520,
      ' 1- 2-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.617175,
      ' 7- 9-1977',
      NULL,
      NULL,
      NULL,
      51.420051,
      NULL,
      24.995669,
      ' 3-17-1987',
      9.125297,
      2.268452,
      NULL,
      15.543433,
      NULL,
      ' 4- 6-1974',
      2,
      2.129247,
      ' 3- 4-1977',
      NULL,
      NULL,
      NULL,
      3,
      0,
      9.597490,
      '11-15-1982',
      35.189296,
      28.245678,
      33.948386,
      ' 7- 6-2002',
      2.207635,
      97.272201,
      ' 9-24-1995',
      NULL,
      NULL,
      NULL,
      38.021148,
      '11-21-1988',
      NULL,
      NULL,
      278,
      ' 1-27-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


