set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7403992';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      NULL,
      '2',
      '2',
      '0',
      '4',
      '0',
      '4',
      '2',
      '2',
      '2',
      NULL,
      '0',
      '2',
      '2',
      '3',
      '1',
      '2',
      '1',
      '4',
      NULL,
      '0',
      '4',
      NULL,
      '0',
      '',
      '2',
      '2',
      '3',
      '3',
      '3',
      NULL,
      '',
      NULL,
      '4',
      '0',
      NULL,
      '1',
      '3',
      '4',
      '1',
      '2',
      '1',
      NULL,
      NULL,
      NULL,
      90.164989,
      63,
      '3213022',
      3.491687,
      45.471759,
      2,
      1,
      '141243',
      NULL,
      ' 3-12-2000',
      ' 9- 3-1977',
      95,
      84.600464,
      7.172605,
      10.541049,
      NULL,
      3,
      17,
      NULL,
      NULL,
      7,
      NULL,
      6,
      NULL,
      9,
      NULL,
      4.910046,
      3.104428,
      5.495383,
      NULL,
      9,
      10.311795,
      NULL,
      3.462915,
      6.394211,
      NULL,
      26,
      35.569451,
      NULL,
      173,
      103,
      40.438011,
      NULL,
      17.753470,
      NULL,
      NULL,
      24.484833,
      123,
      98.363979,
      ' 1-27-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      76.102634,
      10,
      6,
      10,
      2,
      4,
      ' 2- 9-1997',
      0.796999,
      1.066672,
      60.644249,
      1,
      0,
      76,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 0-2002',
      32.330320,
      NULL,
      68,
      66,
      37,
      NULL,
      18.887157,
      64.062647,
      NULL,
      33,
      NULL,
      NULL,
      ' 3- 7-1991',
      9.131354,
      13,
      4.457062,
      30,
      24,
      62.488128,
      11,
      ' 8- 4-1980',
      2.760254,
      3.889197,
      ' 1-15-1986',
      3.182216,
      13.607971,
      1,
      5,
      5,
      2.185415,
      0,
      NULL,
      1,
      14,
      2.532918,
      0.833820,
      5,
      1.380364,
      0,
      13,
      0,
      0,
      ' 3-14-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '11- 6-1984',
      NULL,
      NULL,
      NULL,
      3,
      ' 9-24-1997',
      NULL,
      ' 2-23-1992',
      2,
      5,
      ' 8-25-1979',
      60,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      15,
      ' 8- 9-1997',
      36.438155,
      19,
      NULL,
      '10-23-1996',
      0,
      166.615644,
      NULL,
      NULL,
      77,
      NULL,
      39,
      '10-22-1984',
      2.576662,
      1,
      36.073823,
      '10-17-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


