set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8906086';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2123',
      '32203132',
      '44103001',
      NULL,
      '11232201',
      NULL,
      '31323240',
      '33113442',
      '32431022',
      NULL,
      '32332212',
      '04042044',
      '42403121',
      NULL,
      '34322121',
      '42313230',
      '02121214',
      '23121204',
      '21233230',
      NULL,
      '31333131',
      '40030244',
      '24314302',
      '40303214',
      '40002002',
      '24434210',
      '23112001',
      '41241130',
      '24433242',
      '02113141',
      NULL,
      '23103231',
      '41103110',
      '42130230',
      '42000221',
      NULL,
      '10411220',
      '44104110',
      '14442422',
      '40441010',
      NULL,
      '02100311',
      '40100114',
      NULL,
      '13243441',
      '',
      '',
      NULL,
      NULL,
      '1232144',
      3.195795,
      1,
      1,
      NULL,
      '401042',
      0.086975,
      ' 6-25-1991',
      ' 2-10-1981',
      19.887235,
      NULL,
      4.433582,
      4,
      18,
      12,
      NULL,
      0.087286,
      NULL,
      0,
      16.267027,
      10.254664,
      26.165000,
      5.052701,
      10,
      3.526003,
      4,
      6,
      12,
      2.247603,
      0,
      0.092366,
      43.087122,
      2,
      NULL,
      76,
      143.706499,
      26.384844,
      89,
      114,
      53.776100,
      ' 4-21-1998',
      1,
      7.802885,
      20.687732,
      3.826868,
      117.988037,
      146.210395,
      ' 8- 2-1976',
      3,
      NULL,
      1,
      2.960885,
      NULL,
      NULL,
      NULL,
      NULL,
      1.576779,
      0.710632,
      NULL,
      1,
      1.808872,
      1.970189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-18-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-20-1994',
      NULL,
      NULL,
      91.686344,
      63.109712,
      61.086017,
      29,
      3.927738,
      NULL,
      92,
      95,
      52,
      3.011082,
      '11- 0-1994',
      12,
      1.654588,
      15.235492,
      28,
      26,
      NULL,
      2.635464,
      ' 8-27-1989',
      8,
      1.351188,
      ' 6-16-1975',
      5.543718,
      2,
      11.515353,
      NULL,
      6,
      NULL,
      NULL,
      4,
      NULL,
      34.060681,
      0.946286,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 0-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46,
      1,
      3,
      NULL,
      4.984486,
      NULL,
      ' 8-16-1976',
      2.834524,
      NULL,
      14,
      74.366022,
      ' 9-28-1991',
      NULL,
      0.644526,
      42.071158,
      ' 3- 7-1980',
      NULL,
      NULL,
      NULL,
      0,
      58.647462,
      36.146987,
      1.594236,
      39.043611,
      31,
      32,
      NULL,
      11.153545,
      150.256591,
      3.563738,
      NULL,
      NULL,
      1,
      99,
      0,
      1.388604,
      NULL,
      NULL,
      2.296623,
      6,
      1.393252,
      3.370623,
      293,
      54,
      25.009391,
      25.022407,
      1.820618,
      34.972402,
      NULL,
      1.757664,
      1,
      NULL,
      NULL,
      NULL,
      65.405911,
      1,
      54,
      NULL,
      NULL,
      NULL,
      2.681871,
      2,
      18.332254,
      0.406883,
      0,
      NULL,
      13,
      2.999793,
      8,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      7,
      33.559257,
      14,
      8,
      NULL,
      4,
      24,
      6.108292,
      0,
      NULL,
      3,
      1.101740,
      1,
      NULL,
      '10- 8-1994',
      NULL,
      ' 7- 8-1990',
      NULL,
      ' 4- 7-1995',
      NULL,
      ' 4- 2-1997',
      NULL);
commit;
end;
/


