set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8906086';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '03004100',
      '14140341',
      '20330201',
      '24332044',
      '21011021',
      NULL,
      NULL,
      '42142222',
      '02140003',
      '31330111',
      '02311102',
      '33011002',
      '22023241',
      NULL,
      '04402220',
      '30440144',
      '40420424',
      '32344033',
      NULL,
      '32210200',
      '24433210',
      '41042314',
      '34144224',
      '11224210',
      '04124131',
      '34440230',
      '32442121',
      '00132432',
      '10422002',
      NULL,
      '00442114',
      NULL,
      '32131100',
      '43321204',
      '31111143',
      '22120400',
      '44122403',
      NULL,
      '03402142',
      '11402230',
      '14320203',
      NULL,
      NULL,
      '20341021',
      NULL,
      '',
      NULL,
      NULL,
      '3032134',
      1.228061,
      NULL,
      2,
      NULL,
      NULL,
      3,
      ' 2-16-1980',
      ' 8-16-1988',
      NULL,
      NULL,
      28,
      NULL,
      NULL,
      12,
      13,
      0,
      NULL,
      0.273664,
      NULL,
      2,
      NULL,
      7.521821,
      13,
      NULL,
      33,
      21.711957,
      45.049160,
      0,
      27,
      NULL,
      25,
      2,
      NULL,
      64,
      93,
      17,
      NULL,
      25,
      79,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.436661,
      1.608589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.127113,
      1.687543,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-12-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      114.441358,
      7.995904,
      NULL,
      120.457922,
      78,
      31.184239,
      69.845503,
      19.262815,
      22.114373,
      9,
      62.504729,
      NULL,
      ' 7-24-1988',
      11,
      15,
      NULL,
      19.339450,
      36.526432,
      4,
      9,
      ' 6-19-1986',
      7.241911,
      1,
      ' 5-27-1977',
      2.377219,
      0,
      1.225027,
      5,
      NULL,
      12,
      NULL,
      13,
      NULL,
      36.180495,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-26-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26.906397,
      6.920633,
      16,
      ' 3-21-1996',
      0.595133,
      71,
      '11-10-1987',
      NULL,
      19,
      15.587252,
      59.468986,
      ' 1-24-1996',
      9.059488,
      0,
      NULL,
      ' 5-27-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      15,
      NULL,
      39.870968,
      106,
      27.665174,
      27.488062,
      5,
      NULL,
      2,
      42.725703,
      0.522586,
      NULL,
      8,
      1,
      1,
      NULL,
      7.644965,
      2.708895,
      102,
      8,
      2,
      79.002983,
      42.695095,
      1,
      37,
      0.093547,
      25.756993,
      4.994335,
      0,
      0,
      0.005431,
      0.865856,
      0,
      66.442639,
      NULL,
      23,
      NULL,
      77,
      53,
      0.099560,
      0,
      2.750840,
      0.207175,
      5.172347,
      3,
      5,
      1.726950,
      65,
      0.548026,
      61,
      1,
      0,
      72,
      NULL,
      1.079461,
      7.254752,
      NULL,
      80.029503,
      12,
      3,
      1,
      NULL,
      1,
      1,
      0,
      0,
      1.059974,
      NULL,
      NULL,
      '11-28-1976',
      '11-15-1978',
      ' 1- 0-1990',
      ' 0-16-1995',
      ' 0-14-2000',
      ' 0-26-1989',
      '10-10-1975',
      NULL);
commit;
end;
/


