set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8906086';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0234',
      '24010043',
      '12243240',
      '02023233',
      '11243044',
      '12020230',
      '04134331',
      '44411132',
      '30431322',
      '32024100',
      '40000002',
      '42000204',
      '11221232',
      '43103440',
      NULL,
      '11220041',
      NULL,
      '04210213',
      '21102244',
      '20030311',
      '33031232',
      NULL,
      '02102003',
      '02133220',
      NULL,
      '24240422',
      '41301102',
      NULL,
      '03004133',
      NULL,
      '14430444',
      NULL,
      '12401300',
      '00031220',
      '14124210',
      '22312242',
      '13004110',
      '42430323',
      '02433232',
      '11000124',
      NULL,
      '33404124',
      '32302031',
      '04004030',
      '34320222',
      NULL,
      '32',
      7,
      18.542232,
      '1020232',
      1.810923,
      36,
      NULL,
      NULL,
      '310043',
      5,
      ' 7-22-1995',
      NULL,
      NULL,
      35,
      26.004819,
      3,
      17,
      15.195838,
      NULL,
      1,
      5.110531,
      5.731951,
      NULL,
      4.408948,
      25,
      0,
      2.999644,
      18,
      14,
      2,
      23,
      5,
      NULL,
      10,
      113,
      5.179903,
      0,
      18.440626,
      23,
      24,
      108.076534,
      73,
      33.919031,
      ' 3- 6-1978',
      NULL,
      42.216730,
      1,
      NULL,
      144,
      167.346956,
      '10-14-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      68,
      30,
      8.087550,
      NULL,
      9.202871,
      NULL,
      ' 6-22-1990',
      1.009525,
      1,
      132.396700,
      3,
      2.402296,
      38.409684,
      1.894584,
      NULL,
      35,
      NULL,
      NULL,
      NULL,
      ' 2-10-1987',
      40,
      56,
      72.937151,
      69.848648,
      19,
      46.961887,
      82,
      NULL,
      58.402086,
      82.546027,
      NULL,
      NULL,
      ' 4-29-1974',
      25.483417,
      11,
      12,
      58.779976,
      12.111803,
      26,
      11.374690,
      ' 6- 0-1989',
      12,
      2.007427,
      ' 1-22-1982',
      1.753967,
      6.725072,
      10.781502,
      0.829124,
      5,
      5,
      NULL,
      NULL,
      1.102032,
      NULL,
      1,
      3.568389,
      2,
      5.696035,
      3,
      0,
      3.758327,
      2,
      ' 9- 2-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      173,
      NULL,
      ' 8- 2-1986',
      NULL,
      NULL,
      NULL,
      8,
      '11- 4-1998',
      18.037783,
      '11-25-1979',
      13.647394,
      8.579711,
      '10- 4-1989',
      27,
      65.229718,
      '11- 7-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      19.849158,
      ' 0-28-1997',
      NULL,
      27.623031,
      28,
      ' 8-12-1994',
      3,
      185.389969,
      ' 7- 3-2002',
      3,
      NULL,
      13,
      57.711889,
      NULL,
      47.000252,
      0,
      166.240915,
      ' 6- 8-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


