set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8906086';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '0',
      '3',
      '1',
      '2',
      '0',
      '1',
      '1',
      '1',
      '3',
      '2',
      '3',
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '4',
      '3',
      '3',
      NULL,
      '4',
      '1',
      '3',
      '',
      '4',
      '',
      '0',
      '3',
      '1',
      '0',
      NULL,
      '',
      '',
      '0',
      '2',
      '2',
      '0',
      '2',
      NULL,
      '0',
      '0',
      '4',
      '1',
      NULL,
      NULL,
      '10204231',
      55,
      26,
      '1221123',
      NULL,
      38,
      0,
      NULL,
      '433311',
      3.664685,
      ' 5-26-1980',
      '11- 3-1983',
      79,
      255,
      19,
      8,
      7,
      9.074786,
      64.005526,
      14,
      5,
      10.453332,
      6,
      4,
      NULL,
      NULL,
      9,
      0.278535,
      5,
      NULL,
      28.197809,
      11.551096,
      46,
      NULL,
      84.488253,
      6.215916,
      0.553272,
      61,
      14.498629,
      7,
      86.924147,
      74,
      NULL,
      ' 1-22-1999',
      8,
      13,
      1.068456,
      23.868496,
      107.801546,
      NULL,
      ' 0- 2-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      1.567450,
      2,
      2.014319,
      ' 3- 8-2003',
      1,
      1,
      148,
      1,
      3.886222,
      19.278501,
      NULL,
      1.322317,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 7-1984',
      22,
      12,
      16,
      NULL,
      37.995982,
      2,
      74.370293,
      5,
      9,
      27.324340,
      43.544921,
      3,
      ' 6-23-1981',
      NULL,
      6.532500,
      21,
      8.050182,
      9.923295,
      60.724754,
      9.644234,
      ' 8- 9-1985',
      4.606960,
      NULL,
      ' 2- 7-1977',
      1.002466,
      4.919907,
      6.562887,
      10,
      6.804310,
      NULL,
      0,
      7,
      NULL,
      12.657030,
      10.101935,
      0.612317,
      NULL,
      16.054287,
      9.101956,
      0,
      1.691574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.749271,
      ' 9-18-2003',
      NULL,
      NULL,
      NULL,
      9,
      ' 6- 0-1993',
      20.794837,
      ' 5-18-1980',
      0,
      0,
      NULL,
      131.754012,
      89,
      ' 5-29-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      21.522780,
      NULL,
      1.154595,
      NULL,
      ' 6-25-1990',
      3,
      75,
      14,
      21.800099,
      NULL,
      4,
      0.041775,
      7.080704,
      ' 8-21-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


