set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '3271113';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '2',
      '2',
      NULL,
      '4',
      '2',
      NULL,
      '1',
      '1',
      NULL,
      '3',
      '1',
      '2',
      '3',
      '4',
      '2',
      '2',
      '3',
      '2',
      NULL,
      '2',
      '3',
      '3',
      '3',
      '',
      '4',
      NULL,
      '0',
      NULL,
      '2',
      '3',
      '3',
      '',
      NULL,
      NULL,
      '4',
      '4',
      '1',
      '0',
      '4',
      NULL,
      '3',
      '2',
      NULL,
      '0',
      '113',
      '0',
      62.519885,
      NULL,
      '4432323',
      NULL,
      1,
      2,
      0,
      '224320',
      NULL,
      ' 2- 2-1987',
      ' 4-12-2000',
      16,
      12.369715,
      33.131514,
      8,
      NULL,
      10.085211,
      59,
      29.444396,
      NULL,
      6,
      59.288926,
      28,
      NULL,
      10,
      12,
      0.105331,
      3.207171,
      20,
      96,
      5,
      49.090815,
      18,
      127.603675,
      13,
      1,
      NULL,
      26.031793,
      60,
      171,
      20.218171,
      108,
      ' 2-26-1986',
      42.306703,
      55.101051,
      0,
      39,
      156,
      235.645864,
      ' 1- 5-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      116.514599,
      9,
      9.016620,
      1.793666,
      7.371696,
      NULL,
      NULL,
      1.725437,
      NULL,
      182.758770,
      NULL,
      0.958345,
      150.821511,
      0.123840,
      3.487114,
      43.328330,
      NULL,
      NULL,
      NULL,
      ' 8-14-1999',
      109,
      107.872934,
      NULL,
      51.233221,
      NULL,
      0,
      35.518185,
      41,
      60.830307,
      40.749786,
      NULL,
      41,
      ' 0-29-1987',
      10,
      41.139907,
      19.446140,
      12,
      20,
      19.963633,
      1,
      NULL,
      30.168477,
      NULL,
      ' 3-13-1986',
      NULL,
      19.386859,
      3.911338,
      NULL,
      NULL,
      NULL,
      0,
      9,
      NULL,
      8.844552,
      1.679782,
      2.690473,
      NULL,
      30,
      NULL,
      0.327957,
      1.600038,
      0.815259,
      '11- 5-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      NULL,
      15.308877,
      ' 0-24-1986',
      13,
      21.644478,
      ' 6-29-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      23.878144,
      NULL,
      63.670625,
      22,
      38,
      '11-27-1975',
      0,
      42,
      ' 0- 1-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


