set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6510781';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '32440442',
      NULL,
      '43123212',
      '21203412',
      '10312404',
      NULL,
      '14004022',
      '34331204',
      '12313214',
      '41110302',
      NULL,
      '10334024',
      '40401043',
      NULL,
      '11101200',
      '14014020',
      '32224001',
      '44034042',
      NULL,
      '11421342',
      '03234021',
      '30014440',
      '02434112',
      '12130403',
      '42242121',
      '13314122',
      '22304414',
      '44211114',
      '30010203',
      '31414413',
      '10410020',
      NULL,
      '12403031',
      '43342333',
      '20023214',
      '21444431',
      NULL,
      '30103120',
      NULL,
      '31330343',
      '12012411',
      NULL,
      NULL,
      '02000234',
      '203',
      '11',
      NULL,
      NULL,
      '1401143',
      0.307913,
      1.914502,
      2,
      NULL,
      '134004',
      5,
      ' 3- 6-1975',
      NULL,
      101,
      NULL,
      18,
      0,
      13,
      4,
      47.518847,
      7.007422,
      2,
      NULL,
      32,
      5.248545,
      4,
      NULL,
      NULL,
      12.606636,
      NULL,
      8.776775,
      27.076468,
      14,
      16.509278,
      2.779699,
      NULL,
      6.516046,
      1.638720,
      NULL,
      96,
      34,
      146,
      29.396924,
      150.564735,
      ' 1-16-1999',
      33.138666,
      20.460054,
      10.656851,
      19,
      89,
      111,
      ' 2-18-1993',
      2.513586,
      2.453222,
      0.446016,
      14,
      13,
      3.325852,
      4,
      13,
      1.979712,
      0,
      NULL,
      1.940413,
      0,
      NULL,
      3,
      NULL,
      8,
      NULL,
      1,
      8.915770,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-13-1974',
      39.796530,
      25,
      22.251103,
      NULL,
      14,
      2.681568,
      NULL,
      0.138519,
      0.442710,
      13.050244,
      0.577194,
      3,
      NULL,
      0,
      1.433559,
      22,
      NULL,
      0.557046,
      NULL,
      ' 7-12-1998',
      79,
      NULL,
      26,
      21.702901,
      23.922866,
      0.150590,
      12.942060,
      13.153716,
      9,
      15,
      55,
      NULL,
      ' 8- 6-1999',
      18.449313,
      5.739881,
      4.985104,
      NULL,
      13,
      55,
      0,
      ' 0-12-1987',
      4,
      0,
      NULL,
      1,
      NULL,
      16,
      17,
      7.707139,
      1.890993,
      1.945253,
      NULL,
      1.909639,
      NULL,
      1,
      NULL,
      2.546425,
      11,
      1.139140,
      NULL,
      1.796866,
      1.305259,
      ' 0-14-1983',
      5,
      1,
      2.732325,
      ' 9-21-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      ' 3-20-1985',
      6,
      ' 9- 1-1992',
      NULL,
      1.783845,
      ' 8-21-1980',
      30,
      58.365778,
      ' 2-29-1974',
      0.033249,
      5.478632,
      NULL,
      1.157349,
      7.021108,
      ' 7- 8-1993',
      2,
      3,
      12,
      ' 6- 6-1989',
      NULL,
      8.995320,
      22.406726,
      ' 9-15-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.648609);
commit;
end;
/


