set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9410123';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '34124244',
      NULL,
      '04421243',
      NULL,
      NULL,
      '10142312',
      '33402133',
      '22202241',
      '12030122',
      '23324202',
      NULL,
      NULL,
      NULL,
      '21232101',
      '02144020',
      '31324222',
      '33202343',
      NULL,
      '41101000',
      '30344210',
      '40440133',
      '00122143',
      '14401100',
      '13411100',
      '03340122',
      NULL,
      '43442034',
      '04131100',
      '34123302',
      '00041040',
      '13402110',
      '42040121',
      '14314044',
      '32243433',
      '33132123',
      '13400442',
      '43113143',
      '20441424',
      '44233102',
      '42222211',
      '24313034',
      '20414422',
      '03330302',
      '10301213',
      '003',
      NULL,
      NULL,
      NULL,
      '0313111',
      NULL,
      1.040971,
      0,
      NULL,
      '243443',
      5,
      ' 5-28-1999',
      ' 1- 2-1988',
      40,
      NULL,
      16.705750,
      NULL,
      13,
      12.348060,
      34.431854,
      7.508424,
      NULL,
      NULL,
      5.408522,
      NULL,
      24.538505,
      8,
      6,
      9,
      4.083189,
      8,
      2,
      12,
      43,
      0,
      19,
      9,
      0,
      42.962937,
      145.491028,
      NULL,
      0,
      72.100574,
      NULL,
      NULL,
      36.825710,
      21,
      20,
      22.448223,
      NULL,
      97,
      ' 7-13-1975',
      NULL,
      2,
      2.096822,
      NULL,
      2,
      2.548302,
      0,
      0.135546,
      1,
      1,
      0.390897,
      1,
      1.522291,
      NULL,
      0,
      0.283034,
      3.297766,
      0,
      1,
      3.810658,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-21-2003',
      NULL,
      NULL,
      5,
      4.745412,
      25,
      5.526066,
      NULL,
      NULL,
      1.585978,
      41.996339,
      NULL,
      NULL,
      65.263274,
      1,
      1.809616,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 9-1975',
      59,
      55,
      44.848169,
      26.815480,
      4.473863,
      30.187570,
      NULL,
      35,
      19.515329,
      11.330251,
      39.224905,
      34.765604,
      ' 3-23-2001',
      9.758835,
      6.180084,
      4,
      3.611220,
      NULL,
      1,
      2,
      ' 5-14-1984',
      3.153639,
      8,
      ' 3- 3-1981',
      8.667690,
      4.185508,
      6.973525,
      8.827862,
      6.893842,
      4.056690,
      1.019585,
      8,
      1,
      NULL,
      1.874164,
      0.267413,
      1,
      2.592607,
      0.926024,
      7,
      NULL,
      NULL,
      ' 5-10-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      43.626962,
      13,
      ' 0- 5-1996',
      NULL,
      NULL,
      NULL,
      17,
      ' 2- 4-1974',
      46.797303,
      NULL,
      5,
      13.525798,
      ' 8-10-1986',
      NULL,
      NULL,
      NULL,
      6.472640,
      7,
      ' 3-19-1977',
      NULL,
      NULL,
      NULL,
      0,
      2,
      3.176097,
      ' 9- 5-1996',
      44.073562,
      9.971411,
      15,
      ' 7-19-1987',
      1.685207,
      116,
      NULL,
      3.515970,
      27.274033,
      3.145234,
      NULL,
      ' 7-15-1980',
      58,
      1.382490,
      134.757755,
      ' 5-22-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


