set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9410123';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '40213000',
      '03131122',
      NULL,
      NULL,
      '44404130',
      NULL,
      '00232112',
      '30420242',
      '42404402',
      '00023010',
      '42130300',
      '10041121',
      '33433044',
      '01022311',
      NULL,
      '43032144',
      '24043330',
      '43214123',
      '11101343',
      '01140314',
      '22221440',
      NULL,
      NULL,
      NULL,
      '24323102',
      '21142132',
      '42022434',
      '01332103',
      '12200441',
      NULL,
      '20342033',
      '11220014',
      '43440430',
      '20442120',
      '04434101',
      '23223124',
      '10224412',
      '04243431',
      '11201320',
      NULL,
      '01332432',
      '01343203',
      '14104200',
      NULL,
      NULL,
      '34',
      32.740870,
      NULL,
      NULL,
      3.794629,
      34,
      3,
      NULL,
      '020214',
      2.415546,
      '11-18-1975',
      ' 0-23-1980',
      66.047114,
      123.726725,
      31,
      17.201134,
      2.572967,
      NULL,
      4,
      6.352633,
      17.899424,
      14.609309,
      19.200110,
      10,
      12,
      6.590810,
      NULL,
      NULL,
      11,
      4,
      33,
      7,
      47,
      6.464355,
      81,
      10.917742,
      0,
      NULL,
      25.627444,
      75.133479,
      77,
      0,
      157.809853,
      NULL,
      10.317137,
      21,
      15,
      NULL,
      NULL,
      62,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40.496450,
      33.130102,
      0,
      6.704916,
      NULL,
      3,
      ' 7-24-2000',
      1.073897,
      0,
      180,
      NULL,
      1,
      14,
      1.377639,
      NULL,
      63.556518,
      NULL,
      NULL,
      NULL,
      ' 3- 1-1998',
      20.923568,
      19,
      65.410107,
      8.887833,
      10,
      57.264826,
      0,
      30,
      1.663954,
      31,
      52.329057,
      47.786064,
      ' 2-10-1977',
      23,
      9.053996,
      7.498570,
      64,
      NULL,
      45,
      0,
      NULL,
      NULL,
      16,
      '11-14-1975',
      10.525182,
      8,
      4,
      NULL,
      NULL,
      11.323997,
      0.601316,
      10.499968,
      0,
      87,
      3,
      1,
      9.905465,
      22.012431,
      1,
      0.569511,
      0.591881,
      NULL,
      ' 1-15-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-29-1988',
      NULL,
      NULL,
      NULL,
      10.672859,
      ' 4- 4-1986',
      NULL,
      ' 8- 3-1989',
      7,
      7.212996,
      '10-21-1993',
      42.109571,
      NULL,
      ' 6- 1-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      14.969984,
      ' 5-21-1977',
      NULL,
      12.231201,
      NULL,
      NULL,
      1,
      12.998195,
      ' 8-29-1996',
      NULL,
      57,
      2,
      25,
      ' 8- 8-1999',
      35,
      0,
      36,
      ' 4-20-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


