set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9410123';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '2',
      NULL,
      '3',
      '2',
      '3',
      '1',
      '0',
      NULL,
      '0',
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      '3',
      '2',
      '4',
      NULL,
      '4',
      '1',
      '3',
      '1',
      '1',
      '',
      NULL,
      NULL,
      '3',
      NULL,
      '2',
      '3',
      '4',
      '',
      NULL,
      '3',
      NULL,
      '0',
      '4',
      '2',
      '3',
      NULL,
      '4',
      '3',
      '2',
      '0',
      NULL,
      '31143121',
      13.379999,
      NULL,
      NULL,
      NULL,
      57.119396,
      0,
      NULL,
      '234220',
      0,
      ' 6-22-1988',
      ' 1- 0-1994',
      NULL,
      251.888212,
      43,
      NULL,
      25,
      12,
      33,
      12,
      9,
      18.769222,
      10,
      12,
      24.727710,
      6.006944,
      23,
      12,
      8.820502,
      4,
      NULL,
      NULL,
      50.250827,
      NULL,
      32.920197,
      13.542593,
      NULL,
      23,
      178,
      34,
      24.206044,
      NULL,
      166,
      ' 5- 3-1991',
      1,
      NULL,
      12.293393,
      30,
      122.632365,
      NULL,
      ' 9-11-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      48,
      NULL,
      1.452072,
      8,
      NULL,
      2.643310,
      ' 1-17-1983',
      1,
      1,
      100.560246,
      1,
      3.903888,
      55.201034,
      0,
      NULL,
      29.767172,
      NULL,
      NULL,
      NULL,
      NULL,
      88.636129,
      NULL,
      NULL,
      NULL,
      NULL,
      4.274112,
      NULL,
      NULL,
      22,
      54.240733,
      34,
      47.450002,
      NULL,
      NULL,
      11.899765,
      10.088471,
      36.091118,
      NULL,
      18.375558,
      11,
      ' 9-16-1977',
      11,
      12,
      NULL,
      7.993782,
      3,
      10,
      6,
      24.638575,
      6.629728,
      3,
      NULL,
      1.622269,
      85.944384,
      4,
      1.291543,
      0.270407,
      23.280837,
      NULL,
      2.347628,
      NULL,
      NULL,
      '11-18-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      30,
      9,
      ' 2-12-1984',
      NULL,
      NULL,
      NULL,
      8,
      ' 4-19-1982',
      NULL,
      ' 6-25-1987',
      NULL,
      4.380176,
      ' 4-20-2001',
      75,
      101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      ' 5-14-1997',
      26.258573,
      11,
      0.718869,
      NULL,
      0,
      106,
      ' 9- 7-1996',
      16,
      NULL,
      18,
      42.058580,
      ' 1-27-1980',
      17.156815,
      1.150120,
      73.447316,
      '11-28-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


