set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9410123';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      '1',
      '2',
      NULL,
      '0',
      NULL,
      '0',
      '2',
      '3',
      NULL,
      '4',
      '4',
      '1',
      '3',
      '0',
      '4',
      NULL,
      '4',
      '',
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      '2',
      NULL,
      '',
      '',
      NULL,
      '3',
      NULL,
      '0',
      '1',
      '1',
      NULL,
      '0',
      '1',
      '2',
      '0',
      '021',
      '21342443',
      NULL,
      22,
      '4034423',
      2.425839,
      129.198356,
      1,
      0,
      NULL,
      2.268396,
      ' 0- 0-1989',
      ' 3- 1-2002',
      27.740511,
      237.484304,
      NULL,
      4,
      24,
      5,
      19,
      NULL,
      NULL,
      9,
      10,
      12.514042,
      4,
      NULL,
      2,
      5.347231,
      NULL,
      17.876102,
      NULL,
      1.149053,
      39,
      1,
      NULL,
      14,
      0,
      29,
      NULL,
      1,
      145,
      25.405912,
      NULL,
      ' 0-18-1983',
      NULL,
      NULL,
      NULL,
      20,
      162,
      209.113761,
      ' 1-23-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.912079,
      57.774093,
      8,
      30.586238,
      26.522164,
      2.981911,
      ' 2-20-1982',
      0.361993,
      1,
      NULL,
      0.805473,
      1,
      21,
      0,
      0.545964,
      94.322096,
      NULL,
      NULL,
      NULL,
      '10-16-1994',
      NULL,
      52.965828,
      55.097482,
      NULL,
      73,
      41,
      18,
      40,
      83.777442,
      47.694428,
      32.113984,
      83.678199,
      '11- 6-1986',
      16.495146,
      10,
      18.628255,
      51,
      8.333826,
      3,
      6,
      ' 9-24-2002',
      8.406850,
      12.118740,
      NULL,
      NULL,
      10,
      19.295756,
      NULL,
      20,
      2.154942,
      0,
      13,
      1,
      98.808328,
      1.894554,
      1.714064,
      NULL,
      NULL,
      0.072220,
      3,
      0,
      1.086039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25.253217,
      ' 9-17-1979',
      NULL,
      NULL,
      NULL,
      23,
      ' 8-11-2000',
      28,
      ' 9-26-1998',
      3.602394,
      7,
      NULL,
      7,
      54,
      ' 4- 5-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      5.296133,
      '11- 6-1982',
      NULL,
      2,
      NULL,
      ' 2-10-1974',
      0,
      27.311831,
      '10- 9-1986',
      10,
      29,
      NULL,
      NULL,
      ' 2-22-1987',
      26,
      NULL,
      NULL,
      '10-11-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


