set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703726';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      NULL,
      '0',
      '0',
      '4',
      '3',
      '2',
      '0',
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      '2',
      '1',
      '2',
      '4',
      NULL,
      '4',
      '2',
      '3',
      '',
      '4',
      '',
      '4',
      '4',
      '3',
      '0',
      NULL,
      '',
      '',
      '4',
      NULL,
      '0',
      NULL,
      '3',
      NULL,
      '0',
      '3',
      '3',
      '1',
      NULL,
      '000',
      '12304410',
      NULL,
      13,
      '1140234',
      1,
      0.700156,
      3,
      NULL,
      '422030',
      2.666853,
      ' 3-12-1989',
      NULL,
      79.173317,
      17,
      8,
      0,
      9,
      NULL,
      25,
      NULL,
      6.911890,
      13,
      8,
      8,
      18.752027,
      1,
      NULL,
      9.881409,
      7.076912,
      6.588248,
      49,
      4.635844,
      23,
      1.658059,
      64,
      NULL,
      NULL,
      37,
      NULL,
      51.638706,
      138.819635,
      62.478002,
      40.408249,
      ' 1-29-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26,
      NULL,
      NULL,
      5.389296,
      13,
      1,
      '10- 9-2000',
      1,
      3.834323,
      71,
      0.027564,
      0,
      116,
      1,
      NULL,
      48.525613,
      NULL,
      NULL,
      NULL,
      ' 9- 0-1994',
      54.933194,
      NULL,
      56.744447,
      5.094808,
      86,
      81.194785,
      NULL,
      2,
      4,
      11,
      55,
      29,
      ' 5-27-1991',
      6.084597,
      4.718611,
      18.165579,
      33.787546,
      58.646062,
      20,
      NULL,
      ' 8-13-1988',
      21,
      NULL,
      ' 6-25-2001',
      6.887963,
      6.101467,
      NULL,
      1,
      1,
      0,
      1.168002,
      2,
      0,
      0,
      3.293566,
      NULL,
      NULL,
      21.775710,
      4,
      0.703744,
      NULL,
      1.493753,
      ' 4- 0-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      63.933179,
      3,
      ' 2- 5-2003',
      NULL,
      NULL,
      NULL,
      33.502084,
      ' 2-20-1991',
      30,
      '11-19-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      7.708568,
      '10- 9-1990',
      0,
      13.712174,
      NULL,
      NULL,
      1,
      20.422854,
      ' 0-12-1979',
      2,
      NULL,
      NULL,
      NULL,
      ' 4- 8-2002',
      NULL,
      1,
      193.082189,
      ' 5-22-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


