set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9530492';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '34440221',
      '02244411',
      '40113221',
      '12210424',
      '20331010',
      '24411222',
      '00121042',
      '23034401',
      NULL,
      '21230311',
      '41330424',
      NULL,
      '12410312',
      '04421210',
      NULL,
      '44144201',
      NULL,
      '10303424',
      NULL,
      '00410134',
      '23102000',
      '32214404',
      '40221042',
      NULL,
      '20143314',
      '21321000',
      '11101412',
      '20134411',
      NULL,
      '44111303',
      '11134104',
      NULL,
      '11023210',
      '11042404',
      NULL,
      '12400324',
      NULL,
      NULL,
      '23220224',
      '33443444',
      '41242210',
      NULL,
      '44321312',
      '41121400',
      '234',
      '34',
      NULL,
      NULL,
      '0001033',
      1,
      1.804392,
      2,
      NULL,
      '331010',
      3.534523,
      ' 6- 2-1996',
      ' 2- 6-2002',
      NULL,
      NULL,
      NULL,
      0,
      9.354220,
      6,
      66.804001,
      11,
      5.386242,
      7,
      36.586277,
      7,
      30.858934,
      17.113217,
      5,
      12.434523,
      2.905876,
      0.219334,
      NULL,
      0.559684,
      17,
      0.068444,
      75.419776,
      NULL,
      1.293915,
      11.752641,
      NULL,
      NULL,
      NULL,
      120,
      13,
      ' 6- 8-1990',
      48.248592,
      16.657125,
      39.466980,
      NULL,
      65,
      147.217582,
      ' 3-23-1992',
      3,
      2.463503,
      3.088487,
      0.624528,
      0,
      1.486189,
      16.652843,
      2,
      NULL,
      1.263415,
      NULL,
      0,
      1.903582,
      1,
      0.541902,
      0.163766,
      2,
      1.183221,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-23-1978',
      40.346427,
      18.553637,
      18.404838,
      NULL,
      NULL,
      NULL,
      ' 8-14-2001',
      1,
      NULL,
      NULL,
      3,
      0.355528,
      NULL,
      1,
      0.899887,
      69,
      NULL,
      NULL,
      NULL,
      ' 6-28-1974',
      78,
      72.368930,
      92.055696,
      115.300891,
      35,
      NULL,
      NULL,
      NULL,
      74,
      NULL,
      67.516277,
      49,
      ' 7-18-1995',
      14,
      NULL,
      10,
      NULL,
      28.433360,
      50.766317,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      ' 6-12-1995',
      NULL,
      NULL,
      NULL,
      34,
      ' 4- 9-1979',
      NULL,
      ' 8-12-1992',
      14.196608,
      9.538348,
      NULL,
      112.214120,
      42,
      '11- 3-1999',
      9,
      2,
      ' 9- 0-2003',
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      61,
      8,
      33.423939,
      NULL,
      1.943462,
      47,
      ' 6-17-1995',
      6.381663,
      192.718700,
      18,
      37,
      ' 6- 2-1977',
      67.846622,
      NULL,
      NULL,
      '11-14-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


