set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9530492';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0143',
      '22200204',
      '02033340',
      NULL,
      '03224020',
      '31404330',
      '20344022',
      '23403203',
      '44111101',
      '43141124',
      '41034124',
      NULL,
      '40113322',
      '42012110',
      '22334424',
      '34021102',
      '43113201',
      '01441334',
      '02113011',
      '20441134',
      '20114344',
      NULL,
      '13211233',
      NULL,
      '01423300',
      '13044220',
      NULL,
      '31443400',
      '14114203',
      '23020011',
      '24000200',
      NULL,
      '01113311',
      '43342441',
      NULL,
      '12412331',
      '24244203',
      '00012420',
      '31302103',
      '40110424',
      '24301341',
      '10130013',
      '13421311',
      '12411030',
      '44032312',
      '431',
      '12',
      37,
      NULL,
      '3420023',
      3,
      29,
      0,
      NULL,
      '432010',
      3.168227,
      ' 3- 8-1984',
      ' 8-29-1999',
      99.110329,
      NULL,
      14,
      3,
      4,
      NULL,
      26.229282,
      18.981038,
      8.965819,
      7,
      0.948082,
      3,
      1.533545,
      19,
      NULL,
      8,
      17.822000,
      NULL,
      NULL,
      17.551508,
      20.594900,
      2.975804,
      49,
      4.511052,
      0.780963,
      NULL,
      127.591094,
      51.327448,
      NULL,
      5,
      38,
      ' 5-22-1974',
      48,
      39.004004,
      10,
      32,
      NULL,
      220.397143,
      ' 2-14-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      81.289381,
      4.109421,
      NULL,
      9,
      9,
      3.369909,
      ' 1-14-1976',
      1,
      1,
      90.035975,
      1.835696,
      0,
      36.726279,
      NULL,
      1,
      13.765439,
      NULL,
      NULL,
      NULL,
      ' 6-22-2001',
      7.167313,
      NULL,
      NULL,
      8,
      32.756594,
      30.831787,
      27,
      3,
      14,
      NULL,
      70.167507,
      17.648158,
      ' 4- 0-1996',
      3.627813,
      9,
      NULL,
      43,
      8,
      NULL,
      NULL,
      '10-21-2000',
      25,
      21,
      ' 0-26-1985',
      6,
      15.138463,
      14,
      12.762769,
      6.238744,
      12,
      0,
      NULL,
      1,
      48,
      NULL,
      1,
      14.056545,
      18,
      0.553796,
      1,
      1,
      1.946411,
      ' 5-27-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      29.591542,
      ' 2- 0-1987',
      NULL,
      ' 5- 1-1995',
      NULL,
      NULL,
      ' 0- 7-1974',
      88.741171,
      8.153098,
      ' 0-22-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      19.255263,
      '10-25-1993',
      NULL,
      44.223884,
      24.219120,
      NULL,
      0.310203,
      111.805919,
      ' 5- 0-1987',
      NULL,
      NULL,
      15,
      69.163474,
      ' 9- 3-1985',
      11,
      NULL,
      63,
      ' 4- 3-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


