set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9530492';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      '1',
      '4',
      '0',
      '2',
      '2',
      '0',
      '1',
      '2',
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      '1',
      '2',
      '4',
      '3',
      '2',
      '1',
      '',
      NULL,
      NULL,
      '2',
      '3',
      '0',
      '3',
      '4',
      NULL,
      '',
      NULL,
      '3',
      '0',
      '0',
      '2',
      '2',
      '3',
      '1',
      '2',
      '0',
      NULL,
      '102',
      NULL,
      41,
      43.307880,
      '3130410',
      0,
      NULL,
      0,
      NULL,
      NULL,
      2.564054,
      NULL,
      ' 1-18-1979',
      NULL,
      NULL,
      17,
      NULL,
      0.916401,
      2.870433,
      62,
      NULL,
      8.288377,
      9.460535,
      5,
      14.603753,
      18,
      20.710767,
      20,
      10,
      11.174158,
      5.279109,
      NULL,
      9,
      5.774094,
      8.492668,
      NULL,
      11,
      NULL,
      6.616160,
      92.420113,
      NULL,
      NULL,
      111,
      NULL,
      ' 1-15-1974',
      24.055549,
      27,
      13,
      3.978261,
      82,
      167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      62.612635,
      1,
      30.608422,
      4,
      22.096349,
      NULL,
      ' 5- 0-1989',
      1.183840,
      NULL,
      NULL,
      0,
      0,
      38,
      1,
      1.730358,
      60.089724,
      NULL,
      NULL,
      NULL,
      '10- 5-1977',
      75,
      78,
      42,
      67.833073,
      31.841563,
      4.422714,
      NULL,
      22,
      44.300094,
      38,
      43,
      6,
      ' 1-18-1974',
      12,
      6.620766,
      10,
      16,
      11.345774,
      4,
      7.429598,
      NULL,
      10.990444,
      12,
      ' 5-11-1975',
      NULL,
      NULL,
      7,
      1.848059,
      26,
      NULL,
      1,
      25.118124,
      1,
      61.368273,
      NULL,
      0.648652,
      NULL,
      30,
      1,
      NULL,
      1,
      0.410906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      112.720529,
      70.287214,
      ' 6-21-1975',
      NULL,
      NULL,
      NULL,
      2,
      ' 1-17-1978',
      38.897238,
      ' 5- 6-2003',
      1.887799,
      4.136252,
      ' 4- 6-1975',
      NULL,
      107.506321,
      '10-24-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      ' 3-25-1992',
      59,
      58,
      46,
      '10-24-1987',
      6,
      181,
      ' 8- 8-1976',
      0.762232,
      NULL,
      19.211514,
      99,
      NULL,
      35,
      0.569023,
      6,
      ' 7-11-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


