set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8926229';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4144',
      '44213013',
      '03302333',
      '21312213',
      '34100310',
      '11024142',
      '02241110',
      '22210000',
      NULL,
      NULL,
      '24102034',
      '14022340',
      NULL,
      '44032223',
      NULL,
      '34221321',
      '32131303',
      NULL,
      '02411414',
      '32240011',
      '44013142',
      '32111403',
      NULL,
      NULL,
      '32223001',
      NULL,
      '42224332',
      '00413143',
      '24021044',
      '34102042',
      NULL,
      '10001430',
      '44402041',
      '33441320',
      '31301243',
      '43042334',
      '24000140',
      '22422143',
      '43020300',
      '10032212',
      '41402032',
      '41034304',
      NULL,
      '14211220',
      '41320112',
      '',
      '',
      NULL,
      NULL,
      '0043131',
      NULL,
      1,
      2,
      NULL,
      '321120',
      2,
      NULL,
      ' 5-11-1980',
      19.355099,
      NULL,
      2.882560,
      17,
      NULL,
      5,
      20,
      2.186537,
      12.039654,
      19.543712,
      NULL,
      NULL,
      19,
      0.614732,
      NULL,
      4.367079,
      3,
      6.384203,
      NULL,
      NULL,
      46.316505,
      NULL,
      31,
      2.561496,
      NULL,
      70.774847,
      50.911902,
      NULL,
      107.843219,
      65,
      157,
      ' 3-29-1974',
      11.596830,
      24,
      NULL,
      3.171548,
      29,
      107.877631,
      ' 4-25-1994',
      10,
      NULL,
      0.007670,
      17.281334,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      37.360601,
      1.745464,
      1,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-27-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-15-2002',
      33.091838,
      NULL,
      71.266580,
      74,
      17,
      3,
      NULL,
      45.628704,
      NULL,
      56,
      8,
      52,
      ' 1-27-1999',
      NULL,
      11,
      NULL,
      23,
      11.469242,
      0,
      NULL,
      ' 6-24-1990',
      13,
      5.582761,
      NULL,
      2,
      7.083569,
      6.559582,
      4,
      5,
      NULL,
      NULL,
      2.141827,
      NULL,
      29.643056,
      4,
      2,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-11-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      37.247946,
      5.153237,
      8.084427,
      NULL,
      NULL,
      57,
      NULL,
      NULL,
      29.941157,
      13.756462,
      58.732111,
      ' 1- 6-1997',
      35,
      NULL,
      132,
      ' 6-21-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      15.493834,
      68.321533,
      47,
      85,
      127.186658,
      39.439366,
      47,
      34.681450,
      49.976767,
      3,
      NULL,
      1.009525,
      1.856242,
      12,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7.699838,
      50.771929,
      0.594458,
      506.098966,
      NULL,
      10.444181,
      80.780214,
      1,
      2,
      1,
      0.061404,
      0.300050,
      0.205451,
      0.067484,
      1.142900,
      85,
      57.327216,
      NULL,
      13,
      40.901070,
      NULL,
      1.773005,
      0,
      15,
      NULL,
      1,
      1.869034,
      8.316980,
      1,
      23.547298,
      0,
      NULL,
      0.857566,
      0.904313,
      50,
      27,
      0,
      NULL,
      42.646888,
      26.080504,
      11,
      26.593028,
      6.336688,
      14.923821,
      1,
      7.606504,
      5,
      1.913726,
      1.883773,
      1.872699,
      60,
      NULL,
      ' 0-27-2003',
      ' 5- 9-1975',
      '11-26-1986',
      ' 2- 6-2002',
      ' 9-20-1995',
      ' 6- 2-1997',
      NULL);
commit;
end;
/


