set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9037938';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0322',
      '22131231',
      '04433111',
      '14444042',
      '02041031',
      '00030331',
      '33004413',
      NULL,
      '42111314',
      NULL,
      NULL,
      '11013421',
      '14432111',
      '30143134',
      '00301334',
      NULL,
      '02212033',
      NULL,
      '42144244',
      NULL,
      '34143323',
      '22220330',
      '41340410',
      NULL,
      '23234211',
      '42442412',
      '41010212',
      '04014333',
      '42003011',
      NULL,
      '30431020',
      NULL,
      NULL,
      '10131200',
      '43111413',
      '03340121',
      NULL,
      '03411402',
      '42110420',
      NULL,
      '02403314',
      '40101233',
      '24234212',
      '00300241',
      '24244203',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      1.699369,
      3,
      NULL,
      '000044',
      1,
      NULL,
      '11- 0-1974',
      NULL,
      NULL,
      0,
      13,
      1.840445,
      7,
      30,
      NULL,
      17,
      10,
      5.869457,
      5,
      0.181617,
      NULL,
      NULL,
      6.532487,
      NULL,
      1.787275,
      19,
      1.902944,
      1,
      NULL,
      13.480789,
      1,
      NULL,
      NULL,
      95,
      3.571108,
      135.000310,
      62,
      NULL,
      ' 1-11-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 2-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 0-2000',
      22.087670,
      91.983733,
      67.452060,
      45.871861,
      5.565512,
      NULL,
      45.063300,
      11,
      53,
      10,
      2,
      NULL,
      ' 0- 9-1976',
      0,
      3,
      NULL,
      6,
      4.470371,
      2.159719,
      NULL,
      ' 2- 0-1981',
      NULL,
      NULL,
      ' 6-17-1984',
      1.570596,
      1.566028,
      NULL,
      0,
      NULL,
      1.012069,
      NULL,
      1.252804,
      NULL,
      NULL,
      NULL,
      0.121099,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-20-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20.937561,
      0,
      NULL,
      ' 9-12-1977',
      NULL,
      NULL,
      ' 6-21-1995',
      0,
      72.551875,
      2,
      58,
      ' 9-29-1981',
      69.325339,
      0,
      62.674149,
      ' 9-27-1995',
      NULL,
      NULL,
      NULL,
      8.256894,
      NULL,
      NULL,
      22,
      7,
      0.145758,
      90.030835,
      144,
      11,
      NULL,
      5.972311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      28.253967,
      28,
      NULL,
      NULL,
      31,
      0.914764,
      1.405179,
      NULL,
      NULL,
      0.007702,
      1.790599,
      9.276022,
      2,
      NULL,
      8,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      8.618600,
      NULL,
      1,
      6,
      4,
      0.129909,
      NULL,
      3.925259,
      17,
      5.247537,
      6,
      0,
      26.204015,
      8.606808,
      NULL,
      NULL,
      0,
      1.757908,
      0.653102,
      10.577856,
      ' 8- 2-1987',
      ' 0- 2-1999',
      ' 3- 9-1999',
      NULL,
      '11-27-1981',
      ' 8- 3-1988',
      ' 2-12-1976',
      NULL);
commit;
end;
/


