set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8901642';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0133',
      NULL,
      '20424112',
      '23440140',
      '13321302',
      '43103443',
      '14424323',
      '00130002',
      '11413244',
      '32214331',
      NULL,
      '20020221',
      '24004010',
      '01102440',
      NULL,
      '14133241',
      '32042322',
      '30441021',
      '23312144',
      '34204404',
      '10340413',
      NULL,
      NULL,
      '00341201',
      '13332103',
      NULL,
      '02133404',
      '32042014',
      '01044441',
      NULL,
      NULL,
      '23331041',
      '22441331',
      '14202424',
      '14412321',
      '43400133',
      '44301230',
      '31220211',
      '13301243',
      NULL,
      '34241143',
      '44031120',
      '20311404',
      '14214201',
      '13314444',
      '411',
      '44',
      13.567344,
      NULL,
      '2442400',
      3.317382,
      NULL,
      0,
      NULL,
      NULL,
      1,
      ' 8- 9-1977',
      ' 1-11-1982',
      91,
      15.900540,
      18,
      13,
      13.522055,
      2.272997,
      29.281889,
      5,
      16.627266,
      7,
      3.953161,
      NULL,
      10,
      0.422087,
      12.511815,
      1,
      9.437325,
      15.176663,
      49.978569,
      NULL,
      38.403291,
      4,
      NULL,
      10.961159,
      1,
      20.274993,
      46.229315,
      12,
      43.544477,
      132,
      165,
      ' 7-29-1984',
      7,
      NULL,
      13,
      16,
      99.970635,
      164.569673,
      '10-14-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 5-2002',
      0.131357,
      2,
      93.905824,
      1,
      1,
      61,
      0.825307,
      0,
      17,
      NULL,
      NULL,
      NULL,
      ' 3- 4-1977',
      104.896819,
      115,
      13.435329,
      69.967523,
      58.095012,
      124,
      67.703803,
      125.185058,
      111.595637,
      26.912379,
      23,
      28,
      ' 9-23-1984',
      4,
      4,
      7,
      33,
      9,
      5.986479,
      0.451025,
      NULL,
      NULL,
      NULL,
      ' 6-13-1975',
      6,
      6,
      5,
      NULL,
      6,
      2.990935,
      0,
      NULL,
      NULL,
      4,
      0.016138,
      0,
      9,
      21.213131,
      6,
      4,
      NULL,
      3.335166,
      ' 9-16-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.627711,
      ' 3- 4-1983',
      NULL,
      NULL,
      NULL,
      43,
      ' 1-20-1979',
      26,
      ' 4-29-1994',
      12,
      14.896690,
      ' 3-11-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1.747744,
      ' 7-10-1994',
      29,
      3.036259,
      22,
      '10-28-1997',
      1.461307,
      28,
      ' 1-29-1978',
      0,
      NULL,
      NULL,
      175,
      ' 0- 7-1974',
      NULL,
      0.198383,
      42,
      ' 6-23-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


