set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8921809';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3330',
      '30004423',
      '20004040',
      '24234244',
      '11210130',
      NULL,
      '43302221',
      '11210131',
      NULL,
      NULL,
      '30214131',
      NULL,
      '00222112',
      '14034012',
      '12210112',
      NULL,
      NULL,
      NULL,
      '21424022',
      '40233342',
      '44432221',
      '32011111',
      '33022230',
      '30011242',
      '21433131',
      '34104113',
      '10314221',
      '23314313',
      '44142102',
      '03410433',
      '11212333',
      '14143203',
      '41014124',
      '43120010',
      '34341230',
      '43313241',
      NULL,
      NULL,
      '42423440',
      '13441121',
      '00223424',
      '33444311',
      '33242411',
      '42412321',
      '03302113',
      '',
      '',
      NULL,
      NULL,
      '0223230',
      2,
      0,
      3,
      NULL,
      '140110',
      NULL,
      '11-16-1974',
      ' 4-12-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.805986,
      36.208468,
      8,
      18.074396,
      109.592107,
      65,
      ' 3- 1-1987',
      0,
      0,
      1.331308,
      1.501162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.967498,
      1.566332,
      1,
      0,
      1.497118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-15-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      NULL,
      19.616728,
      86.248028,
      68.860898,
      43,
      47,
      49.238272,
      72.904969,
      NULL,
      NULL,
      NULL,
      ' 1-29-1978',
      4,
      24,
      12,
      NULL,
      NULL,
      48,
      NULL,
      ' 3-28-1980',
      9.441430,
      0,
      ' 7-24-2003',
      15.866765,
      2.264473,
      NULL,
      9,
      17.971198,
      NULL,
      NULL,
      6,
      NULL,
      12.620231,
      1.905051,
      1.531355,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '11- 5-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      64,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      63,
      NULL,
      5,
      NULL,
      1,
      0,
      103,
      1.330137,
      4.452037,
      174,
      24,
      NULL,
      NULL,
      1.761857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      98.494800,
      NULL,
      NULL,
      NULL,
      96.217062,
      NULL,
      1.251382,
      NULL,
      0,
      NULL,
      1,
      28.411888,
      0.051982,
      24,
      0,
      3,
      0.483633,
      5,
      NULL,
      10.354059,
      0,
      21,
      97,
      NULL,
      NULL,
      NULL,
      13,
      1,
      NULL,
      NULL,
      1,
      0,
      1.851789,
      0,
      30,
      NULL,
      NULL,
      NULL,
      ' 7-19-1978',
      '10-23-1994',
      NULL,
      NULL,
      NULL);
commit;
end;
/


