set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8921809';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2043',
      '34200012',
      '20131320',
      NULL,
      '44321324',
      '11404241',
      NULL,
      '22042331',
      '31031021',
      '11022002',
      '01444232',
      '34444343',
      '33121410',
      NULL,
      '24120331',
      NULL,
      NULL,
      '41440102',
      '32102021',
      '31432442',
      '23420411',
      '44234344',
      '02444204',
      '32024043',
      '34302133',
      NULL,
      '03411140',
      '10042411',
      '03301310',
      '32431222',
      '44110210',
      '00221131',
      '23121023',
      '12304223',
      '33030113',
      '01110300',
      '42330441',
      '42213424',
      '13232244',
      NULL,
      '41110024',
      NULL,
      '34340043',
      '30334230',
      '11310014',
      NULL,
      '',
      NULL,
      NULL,
      '0002430',
      1.989290,
      14,
      1,
      NULL,
      NULL,
      NULL,
      ' 9-13-2002',
      ' 8-22-1993',
      35.759869,
      NULL,
      2.977852,
      20,
      5,
      10,
      41,
      16.823769,
      NULL,
      NULL,
      NULL,
      NULL,
      27.122188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      82.154072,
      19,
      NULL,
      NULL,
      59.307200,
      7.988543,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 2-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.971026,
      1,
      2.030181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.765133,
      0,
      1.724856,
      0.010720,
      2.653159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-25-1991',
      NULL,
      44,
      3.104508,
      NULL,
      NULL,
      49,
      13,
      2.087238,
      56,
      60.246118,
      63,
      NULL,
      NULL,
      NULL,
      7,
      27,
      91,
      14.323690,
      104.405784,
      NULL,
      ' 2-11-1991',
      2.643783,
      4,
      ' 2- 6-1988',
      4.385433,
      9.640649,
      16.946569,
      NULL,
      12.243489,
      5.936105,
      NULL,
      13,
      NULL,
      24.123024,
      2.186571,
      4.589707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      42.267412,
      6,
      NULL,
      0,
      43.955545,
      NULL,
      NULL,
      NULL,
      22,
      30.179506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      57.266861,
      13.233976,
      40.535851,
      82.208453,
      2.553585,
      0.767084,
      29,
      15,
      4,
      23,
      0,
      0,
      NULL,
      NULL,
      1,
      98.123832,
      NULL,
      1,
      159.134506,
      0.760281,
      0,
      226,
      64.715822,
      NULL,
      NULL,
      0.005534,
      93,
      NULL,
      0.818118,
      0.949652,
      1,
      0.146052,
      1.498585,
      21.707054,
      NULL,
      NULL,
      NULL,
      NULL,
      76,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.905702,
      1.896296,
      53,
      NULL,
      5.895725,
      0.270935,
      30,
      75,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0.022704,
      0,
      0,
      19.946575,
      ' 2-13-1986',
      NULL,
      NULL,
      NULL,
      ' 3-16-1984',
      NULL,
      NULL,
      NULL);
commit;
end;
/


