set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8921809';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '23402101',
      '11310220',
      '20042144',
      '41230430',
      '44033304',
      '03124143',
      '33044131',
      NULL,
      '21211430',
      '00441030',
      NULL,
      NULL,
      '44132342',
      '43201004',
      NULL,
      '43221402',
      NULL,
      '44030241',
      '01201243',
      NULL,
      '10012234',
      '13013320',
      '41202222',
      NULL,
      '33342111',
      '42133130',
      '24012003',
      '40240413',
      '24444130',
      '03330324',
      NULL,
      NULL,
      NULL,
      '22021310',
      '22400402',
      '34013332',
      '13413442',
      '31143202',
      '10004123',
      '21400330',
      '42413101',
      NULL,
      '14201342',
      NULL,
      '242',
      '33',
      NULL,
      NULL,
      NULL,
      2,
      91,
      0,
      NULL,
      '420431',
      NULL,
      NULL,
      NULL,
      43.322589,
      NULL,
      27,
      15,
      3.692001,
      NULL,
      65,
      7,
      9,
      15,
      18.814292,
      11.366563,
      21.374107,
      7.759829,
      34.244318,
      14,
      4.087946,
      8,
      55.115732,
      6.365438,
      54,
      12.210565,
      NULL,
      9,
      1,
      100.152847,
      128,
      35,
      65,
      NULL,
      NULL,
      ' 7-20-1990',
      NULL,
      NULL,
      22.391666,
      19.419461,
      80.762889,
      54,
      ' 0-10-1980',
      0,
      NULL,
      NULL,
      1,
      1.729877,
      1,
      0,
      0.673161,
      1,
      NULL,
      0.357399,
      NULL,
      1.659530,
      1,
      0.092665,
      NULL,
      1,
      0,
      1,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 7-1997',
      8,
      0.730573,
      5.944402,
      NULL,
      NULL,
      2.197190,
      NULL,
      0.811508,
      NULL,
      113,
      1,
      0,
      128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      18.640152,
      56.541870,
      52,
      NULL,
      NULL,
      NULL,
      NULL,
      69.914632,
      7.691449,
      50.454575,
      30.949275,
      NULL,
      21.349604,
      20.547446,
      12,
      NULL,
      5,
      67,
      7.902389,
      ' 6-10-1992',
      19.444990,
      17.644847,
      ' 7-25-1999',
      8.864605,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1.499677,
      9,
      NULL,
      22,
      0,
      9.124370,
      9,
      26.497038,
      3,
      0.912050,
      0,
      0.469238,
      '11-24-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      ' 8- 7-1975',
      NULL,
      NULL,
      NULL,
      14.529618,
      NULL,
      20,
      ' 7-16-1988',
      NULL,
      4,
      NULL,
      80,
      0,
      ' 2- 1-1986',
      0,
      NULL,
      '11-13-1997',
      NULL,
      NULL,
      NULL,
      0,
      2,
      10,
      NULL,
      32,
      6,
      12,
      '10-29-1990',
      0,
      14.176506,
      NULL,
      10.099682,
      45,
      NULL,
      NULL,
      ' 7-17-1979',
      3,
      1.311728,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


