set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8921809';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '30320403',
      '43040433',
      '44434331',
      '02401034',
      '44111240',
      '23011201',
      '03432204',
      '02102102',
      NULL,
      NULL,
      '13024431',
      '41323140',
      '34110304',
      '03321212',
      '43023112',
      '22303321',
      '40121312',
      '22002113',
      '21034133',
      '24303122',
      '33122403',
      '24422411',
      '20030012',
      '02334321',
      '33001413',
      '23243304',
      '41234311',
      '20434020',
      '13304002',
      NULL,
      '12430413',
      '12430130',
      '22432124',
      '23143324',
      '30100434',
      '22034304',
      '13402044',
      NULL,
      '31321201',
      '01204404',
      '34214212',
      '43430124',
      '30111041',
      NULL,
      '224',
      NULL,
      2.857555,
      NULL,
      '3443124',
      2.968019,
      2,
      3,
      NULL,
      '440120',
      0,
      ' 6-13-1990',
      '10-19-1998',
      3,
      31,
      11.003833,
      NULL,
      25,
      NULL,
      39.566125,
      7.180582,
      6.189755,
      NULL,
      NULL,
      19.313282,
      16.645309,
      NULL,
      12,
      NULL,
      7.680157,
      26.186537,
      96,
      NULL,
      69.218474,
      4,
      69.248832,
      9.760528,
      0,
      NULL,
      56,
      36,
      42.543774,
      125,
      199.207501,
      ' 9-23-2002',
      NULL,
      57.044900,
      35.422827,
      NULL,
      108,
      111,
      ' 4-20-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      116,
      3.127209,
      3.105407,
      NULL,
      NULL,
      NULL,
      ' 1- 4-1988',
      1,
      1,
      55,
      1,
      1,
      29.172064,
      NULL,
      0.685927,
      84.925399,
      NULL,
      NULL,
      NULL,
      ' 3-25-1990',
      53,
      NULL,
      42.943740,
      96,
      64,
      25,
      30.184912,
      66,
      51,
      85,
      84.694478,
      84,
      ' 8- 3-1990',
      22.662521,
      17,
      15,
      79.135669,
      NULL,
      137.693877,
      1.238325,
      ' 6- 0-1989',
      8.189592,
      8,
      ' 8-13-1988',
      2.547314,
      NULL,
      9,
      13,
      3.581500,
      7.021686,
      1,
      7,
      1.688568,
      3.263285,
      6.079062,
      4,
      NULL,
      11,
      6.582996,
      2,
      0,
      NULL,
      ' 3-11-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      86.848703,
      3.734504,
      NULL,
      NULL,
      NULL,
      NULL,
      28,
      '10- 6-1982',
      33,
      NULL,
      8.803004,
      10,
      NULL,
      161,
      NULL,
      '10-19-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      ' 1-18-2000',
      NULL,
      NULL,
      20.049184,
      ' 8- 3-1999',
      NULL,
      177.464025,
      ' 0-29-1983',
      2.834841,
      NULL,
      9,
      NULL,
      ' 5-29-1976',
      17.945653,
      NULL,
      82,
      ' 3-21-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


