set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8921809';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      '0',
      '4',
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      '1',
      '1',
      '0',
      '4',
      '2',
      '4',
      '4',
      '4',
      NULL,
      '4',
      '1',
      NULL,
      '0',
      '',
      '0',
      '',
      '0',
      '4',
      NULL,
      '0',
      '4',
      '',
      '',
      '2',
      '3',
      NULL,
      '2',
      '0',
      '4',
      '3',
      '1',
      NULL,
      '4',
      '4',
      '340',
      '33441011',
      49,
      NULL,
      '2223230',
      NULL,
      NULL,
      3,
      NULL,
      '204141',
      0,
      '10-23-1974',
      ' 7-19-1988',
      61,
      43.719292,
      0.082851,
      10,
      8,
      3,
      66,
      16.403650,
      2.508399,
      NULL,
      10,
      3.798900,
      11,
      9.635662,
      22,
      NULL,
      4.471669,
      16,
      NULL,
      NULL,
      20.160811,
      18,
      NULL,
      2,
      1,
      NULL,
      37.529514,
      NULL,
      NULL,
      58,
      165.335102,
      '10- 0-1975',
      46.284816,
      22.049198,
      NULL,
      9,
      179,
      17.808313,
      ' 4-15-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.672101,
      11.607580,
      22,
      0,
      NULL,
      4.151917,
      ' 4- 5-1983',
      1,
      0,
      157.066508,
      NULL,
      NULL,
      115.704072,
      0.026956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-19-1988',
      NULL,
      34,
      53.643742,
      15.482896,
      67,
      1.472626,
      71,
      NULL,
      NULL,
      66,
      36.109539,
      17,
      ' 1-17-1998',
      4,
      NULL,
      9.890574,
      29,
      47,
      30.348917,
      NULL,
      '10-19-1987',
      19,
      16.383145,
      NULL,
      NULL,
      11.460731,
      4,
      28.321993,
      20.781775,
      5.508750,
      1,
      22,
      1.799742,
      119.212492,
      NULL,
      0.912292,
      5,
      10.985663,
      1.963988,
      NULL,
      NULL,
      0.698616,
      ' 0-28-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      71.296802,
      0.457895,
      ' 3-26-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 2-1980',
      45.402350,
      ' 8-11-1985',
      9.665789,
      NULL,
      '10-25-1977',
      2.231204,
      5,
      '11-13-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      ' 6- 9-1991',
      45.420578,
      NULL,
      1,
      ' 8-21-1989',
      NULL,
      41,
      ' 8-14-1982',
      4.972658,
      27,
      NULL,
      13.836287,
      NULL,
      43.593774,
      1,
      204,
      '11-19-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


