set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8921809';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '0',
      '3',
      '2',
      '1',
      '2',
      '3',
      '2',
      '3',
      '1',
      '4',
      '1',
      '0',
      '1',
      '1',
      '4',
      '1',
      '1',
      '1',
      NULL,
      '1',
      '3',
      '0',
      '2',
      '',
      NULL,
      '',
      '2',
      '4',
      '0',
      '4',
      '3',
      '',
      '',
      '0',
      NULL,
      '0',
      '4',
      NULL,
      '3',
      '3',
      '1',
      '3',
      '2',
      NULL,
      '242',
      '04101241',
      29,
      4.921991,
      NULL,
      2,
      113,
      2,
      1,
      NULL,
      NULL,
      ' 6-29-1979',
      ' 6-20-1976',
      47,
      194.479459,
      15,
      21,
      23,
      16,
      22,
      17.726230,
      4,
      13.795492,
      27,
      19,
      8,
      17,
      NULL,
      24.395975,
      20.692668,
      17,
      11.937208,
      1,
      74.340016,
      19.310308,
      8.887047,
      NULL,
      0.832665,
      79.493060,
      65.134123,
      98,
      187,
      NULL,
      NULL,
      ' 7-25-1994',
      44,
      30.783505,
      23,
      8.319536,
      167.972919,
      15,
      ' 1-15-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      54,
      27,
      NULL,
      12.741267,
      13,
      NULL,
      '10-14-1992',
      1,
      NULL,
      32.566550,
      NULL,
      NULL,
      21.258023,
      1,
      NULL,
      32,
      NULL,
      NULL,
      NULL,
      NULL,
      49,
      6,
      40.490850,
      44,
      27,
      NULL,
      48.478102,
      NULL,
      23.929880,
      31,
      17.453597,
      NULL,
      NULL,
      8.949871,
      22,
      24,
      40,
      78,
      NULL,
      NULL,
      ' 6- 6-1980',
      NULL,
      9.727140,
      ' 9-16-1997',
      1,
      19,
      2,
      NULL,
      NULL,
      NULL,
      0.054609,
      NULL,
      1.805103,
      23.545664,
      0.341676,
      0.011865,
      10.892119,
      19,
      6,
      0,
      0.635812,
      1.282874,
      '10-21-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      78,
      0,
      ' 3- 7-1985',
      NULL,
      NULL,
      NULL,
      54,
      ' 3-17-1983',
      37,
      NULL,
      12,
      0.126421,
      '10-13-1989',
      117,
      54,
      ' 3- 3-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      3.018124,
      ' 2- 6-1997',
      4.048522,
      26.167133,
      23,
      ' 7- 6-1989',
      1.120986,
      50.539470,
      ' 8-26-1980',
      13.425163,
      15,
      22.152146,
      NULL,
      ' 2- 3-1985',
      8.490700,
      1.900531,
      125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


