set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7923058';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2243',
      '44204312',
      '23022112',
      '03313400',
      '02012122',
      NULL,
      NULL,
      NULL,
      '04414014',
      '04314323',
      '11211100',
      '03100142',
      '20020201',
      NULL,
      '12232303',
      '24011242',
      '42031404',
      '43002230',
      '01301310',
      '14414001',
      '12031303',
      '33022241',
      '24212323',
      '12230324',
      NULL,
      '42443422',
      '21001414',
      '23402302',
      '31222121',
      '00300221',
      '13410412',
      '02024214',
      '12431431',
      '00442331',
      NULL,
      '00334034',
      '44021233',
      '42432332',
      '12431304',
      '22124204',
      '22100434',
      '03200010',
      '32432312',
      '14103232',
      '30103240',
      '',
      '',
      NULL,
      NULL,
      '2312142',
      1.756865,
      1,
      2,
      NULL,
      NULL,
      3,
      ' 2-19-1999',
      ' 0-22-1981',
      99.000317,
      NULL,
      NULL,
      11.435439,
      7.502249,
      12.200100,
      27.816653,
      6.070830,
      11,
      6,
      26.031564,
      9,
      NULL,
      4.148514,
      23.260603,
      2.049396,
      6,
      6.543752,
      26,
      3.431565,
      22.698593,
      NULL,
      74,
      6.290319,
      NULL,
      NULL,
      88.835563,
      NULL,
      7,
      49,
      NULL,
      ' 9-19-1982',
      38.841532,
      0.516626,
      NULL,
      NULL,
      97,
      60,
      ' 5- 5-1989',
      1,
      4,
      1.018727,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 3-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.738205,
      36.848429,
      89.923758,
      90.793416,
      137.775943,
      39.562199,
      NULL,
      84,
      9.785639,
      81,
      NULL,
      NULL,
      ' 6-19-1988',
      13.398961,
      12.971607,
      4,
      33,
      37.479474,
      22.689323,
      6.760069,
      '10-25-1985',
      21.067892,
      NULL,
      ' 4-17-1997',
      0.318874,
      14,
      6,
      13.637238,
      11.590395,
      11.601360,
      NULL,
      NULL,
      NULL,
      11,
      5.929143,
      9.002882,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21.390287,
      17.069866,
      3.180937,
      ' 4-18-1980',
      12.241826,
      209.727265,
      ' 3-10-1996',
      6,
      69,
      2.005836,
      NULL,
      NULL,
      24,
      0,
      NULL,
      ' 8-22-1977',
      NULL,
      NULL,
      NULL,
      60.263574,
      NULL,
      NULL,
      18,
      78.236042,
      45.895616,
      35,
      NULL,
      3.150308,
      8,
      0.196971,
      44,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      42.720601,
      1.042480,
      104,
      1,
      0,
      0.793527,
      1.381168,
      NULL,
      1,
      99.191533,
      NULL,
      NULL,
      8.928613,
      20.363712,
      47,
      NULL,
      NULL,
      21.461296,
      1.482366,
      NULL,
      7,
      3,
      0,
      100.250869,
      0.369442,
      128,
      1,
      0,
      80,
      29,
      NULL,
      10,
      3,
      104.061965,
      NULL,
      20.675301,
      5,
      23,
      3.629611,
      8,
      0,
      0.335296,
      0.403084,
      1,
      130.870216,
      NULL,
      ' 4-10-2002',
      '11-20-1983',
      NULL,
      ' 8-13-1987',
      '10- 0-1977',
      ' 3-13-1990',
      NULL);
commit;
end;
/


