set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8433516';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      NULL,
      '4',
      NULL,
      '2',
      '1',
      '1',
      '4',
      NULL,
      '1',
      '1',
      '4',
      '3',
      '1',
      '2',
      '2',
      '2',
      '1',
      '1',
      NULL,
      '2',
      '3',
      '0',
      '',
      '1',
      '',
      NULL,
      '2',
      '2',
      '3',
      '0',
      NULL,
      '',
      '1',
      '0',
      NULL,
      '0',
      '0',
      '3',
      NULL,
      '1',
      '0',
      '1',
      '3',
      '003',
      NULL,
      15.648943,
      17.557215,
      '4224122',
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      ' 6- 0-2001',
      ' 1-29-1985',
      22,
      45.119313,
      33,
      14.232860,
      NULL,
      9,
      91.594478,
      6,
      0.449316,
      4.403411,
      50.314134,
      9,
      12,
      12.894028,
      NULL,
      14.090129,
      13.441572,
      5.876808,
      47.261258,
      10.277665,
      10,
      1.038155,
      40,
      NULL,
      NULL,
      24.869407,
      113,
      74,
      154.033637,
      99,
      41.607073,
      ' 2-27-1999',
      3,
      16.432034,
      28.208951,
      23.541496,
      86.440874,
      105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      62,
      9,
      6.992358,
      4,
      7,
      7,
      '11-18-1978',
      0,
      NULL,
      90,
      1.974430,
      NULL,
      140,
      0,
      1.491036,
      17.623292,
      NULL,
      NULL,
      NULL,
      NULL,
      69.280110,
      NULL,
      77,
      NULL,
      17,
      NULL,
      88,
      102.032114,
      80,
      NULL,
      83.458254,
      0.812988,
      ' 7- 2-1994',
      29.668896,
      24.520340,
      16.609690,
      7.644989,
      89.830998,
      41,
      10.342498,
      ' 8- 6-2001',
      20.219439,
      NULL,
      ' 1- 5-1995',
      10,
      13,
      16,
      2,
      24.786225,
      10,
      0,
      11.754663,
      1,
      NULL,
      NULL,
      1,
      25,
      23,
      1,
      1.466720,
      NULL,
      1.204652,
      ' 9-18-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      177.775128,
      11,
      ' 3-29-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-11-1986',
      NULL,
      ' 3- 6-1983',
      NULL,
      20.582917,
      ' 1-25-2002',
      98.687858,
      79,
      ' 7-10-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      17.277860,
      ' 0- 1-2000',
      11,
      44,
      15.581645,
      ' 2-16-1988',
      1.920334,
      139,
      ' 3-12-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


