set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9323773';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1442',
      '33440411',
      '20404103',
      '20312332',
      '21042444',
      '12414400',
      '31231410',
      '22201124',
      '14003110',
      '04413433',
      '13001242',
      '31021344',
      NULL,
      '31023011',
      '41240223',
      '11231234',
      '24140204',
      '12403414',
      NULL,
      NULL,
      NULL,
      '21110044',
      '22331040',
      '34344413',
      '14430030',
      '42440332',
      '24101420',
      '11142440',
      '22204324',
      '14242324',
      '02420201',
      '40441232',
      '10032433',
      '24331033',
      '03102340',
      '13100410',
      '43101440',
      '23014212',
      '43132400',
      '33031120',
      '24022210',
      '21111334',
      '30311344',
      '11120443',
      '31244112',
      NULL,
      '00',
      NULL,
      NULL,
      '4222410',
      2,
      0.715653,
      2,
      NULL,
      NULL,
      3.796600,
      ' 8-28-1985',
      ' 5-22-1981',
      17,
      NULL,
      30.260439,
      3.102563,
      21.822708,
      14,
      124,
      13,
      5.608266,
      0.645290,
      NULL,
      28,
      0.771806,
      NULL,
      NULL,
      NULL,
      23,
      10.338007,
      3.324355,
      21,
      51.754503,
      2,
      112,
      2.300653,
      0,
      1,
      193,
      96.002615,
      102.426687,
      32.080910,
      13,
      ' 6- 2-1981',
      NULL,
      NULL,
      36.108150,
      11.805062,
      153.001357,
      212,
      ' 0-15-1978',
      2,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1.801578,
      NULL,
      NULL,
      0,
      NULL,
      1.779997,
      1.040459,
      1,
      1,
      1.776459,
      0,
      1.389927,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-14-1998',
      87,
      12,
      NULL,
      3.727195,
      6,
      5.814149,
      ' 5- 2-1986',
      1,
      NULL,
      64,
      0.508363,
      4.730091,
      27,
      0,
      5.319538,
      89,
      NULL,
      NULL,
      NULL,
      ' 1- 1-1996',
      121,
      110.715718,
      NULL,
      45,
      88.875439,
      14,
      107.664882,
      53.740001,
      78.462578,
      21,
      7,
      91,
      ' 9- 9-1994',
      15,
      6,
      4.672970,
      6,
      3,
      141,
      NULL,
      '11-20-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.641777,
      3.987076,
      NULL,
      ' 1-17-1979',
      61.738756,
      5,
      '11-11-2001',
      10,
      5.487892,
      NULL,
      24.849962,
      ' 5-14-1991',
      38.662294,
      NULL,
      2.020565,
      10,
      ' 3-18-1977',
      110,
      11.712413,
      ' 6-27-1984',
      11,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      9.769879,
      ' 0-27-2001',
      7.647518,
      37.704315,
      59,
      ' 5-26-1988',
      0,
      NULL,
      ' 8-21-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.190312);
commit;
end;
/


