set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9109020';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1124',
      '22111110',
      '10441213',
      NULL,
      '23110320',
      '42342110',
      '04432203',
      '21244021',
      '44302021',
      '03333113',
      NULL,
      '20232403',
      '44433031',
      '20103010',
      '02403212',
      '23004311',
      NULL,
      NULL,
      '34421034',
      '02020041',
      '20341401',
      '00220043',
      '34324121',
      '04314044',
      '04011342',
      '40141313',
      '04040001',
      '21423411',
      '33330120',
      '01344134',
      '31343423',
      '13342012',
      '11440423',
      '10311104',
      '24242133',
      '10130330',
      '22221100',
      '21200202',
      '43134002',
      '24404233',
      '01440122',
      '11132243',
      NULL,
      '12032241',
      '32223220',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      NULL,
      '332210',
      NULL,
      NULL,
      '10- 2-1999',
      20,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      25,
      8.910494,
      NULL,
      NULL,
      2,
      34.201980,
      18,
      14,
      NULL,
      19.598894,
      6.182709,
      58,
      9.735192,
      8,
      4,
      51,
      NULL,
      NULL,
      137,
      120.959515,
      NULL,
      NULL,
      55,
      NULL,
      ' 5-26-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.267724,
      1.137830,
      0.137162,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.258950,
      0,
      1.070630,
      0.909878,
      0.888942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.547104,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      30.137017,
      53,
      58.723587,
      88,
      85,
      NULL,
      31,
      13.375383,
      121.476487,
      NULL,
      84.474278,
      41,
      NULL,
      2,
      NULL,
      NULL,
      28,
      NULL,
      95.769562,
      8,
      ' 9-12-1984',
      21,
      0.419685,
      '10- 3-1985',
      12.115952,
      12.926260,
      NULL,
      NULL,
      12,
      8,
      NULL,
      25.839527,
      NULL,
      91,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 7-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41,
      3,
      11.313956,
      ' 1- 3-1975',
      1.926139,
      103.368501,
      ' 8-27-1998',
      2,
      NULL,
      8.214193,
      28.246997,
      ' 0-15-1985',
      0,
      1.060210,
      84,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      76,
      44,
      NULL,
      12.219101,
      0,
      3,
      1.217444,
      13,
      83.174289,
      NULL,
      2.733677,
      37.175213,
      1,
      0.676814,
      NULL,
      NULL,
      0,
      147.186869,
      NULL,
      1.368101,
      NULL,
      39,
      1.836720,
      40,
      0.022812,
      14.083719,
      1,
      1.894353,
      0,
      0,
      1.951913,
      0.212216,
      54,
      NULL,
      89.430310,
      6.321343,
      68.865691,
      79.005085,
      0.678777,
      NULL,
      2,
      NULL,
      29.580510,
      0.526708,
      8.410604,
      0.868247,
      9.553792,
      0.661843,
      63,
      0,
      0.488716,
      67,
      NULL,
      NULL,
      27,
      51.254555,
      59.012348,
      NULL,
      NULL,
      3.718718,
      2,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      9.768014,
      NULL,
      ' 2-27-1984',
      ' 0-17-1997',
      ' 2-28-1980',
      ' 3-21-1981',
      ' 0- 8-1983',
      ' 7-29-1986',
      NULL);
commit;
end;
/


