set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8527538';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0230',
      '20020010',
      '21134031',
      '43112444',
      '24204302',
      '42420230',
      '03420130',
      '11011223',
      '12042434',
      '00014314',
      '40344401',
      '34121340',
      '20321434',
      '33444242',
      '23343442',
      '21202333',
      '34131214',
      '34324122',
      '11343221',
      '02221401',
      '23310331',
      '03041201',
      '23124433',
      '13410212',
      NULL,
      '22424033',
      '41030404',
      '14424104',
      NULL,
      '30123330',
      '23304114',
      '30103313',
      '42423132',
      '11031433',
      '13340304',
      '24013120',
      '03401204',
      '03324043',
      '13113342',
      '31441411',
      '03203114',
      '11213013',
      '30102214',
      '32423033',
      '30324113',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      2,
      1,
      2,
      NULL,
      NULL,
      1.861465,
      ' 9- 5-1987',
      ' 9-18-1984',
      9,
      NULL,
      18.942903,
      16.251559,
      NULL,
      NULL,
      25,
      11.386908,
      14,
      9.905739,
      16,
      NULL,
      21.597433,
      10.752332,
      NULL,
      4.444187,
      2.201867,
      10,
      17,
      19.036097,
      NULL,
      NULL,
      74.108274,
      2.107591,
      NULL,
      70.734369,
      14,
      61.038249,
      7.543150,
      133.968929,
      156,
      NULL,
      NULL,
      29.854265,
      20.411389,
      24.081957,
      59.309121,
      200,
      '11-20-1992',
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.983299,
      NULL,
      NULL,
      1.698127,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-28-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-23-1998',
      34.344284,
      NULL,
      40,
      59,
      4.590696,
      NULL,
      NULL,
      76.039247,
      27.961592,
      29,
      32,
      NULL,
      ' 0-20-1997',
      11,
      NULL,
      13,
      NULL,
      1,
      28,
      NULL,
      '11-17-1985',
      12,
      11,
      NULL,
      4,
      13.145468,
      5,
      16,
      21,
      2,
      NULL,
      6,
      NULL,
      52,
      1.739268,
      NULL,
      9.663141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      54,
      23.093727,
      28.371340,
      '11-16-1989',
      2.981398,
      152,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      ' 6-26-1987',
      35.095338,
      0.987690,
      319.696793,
      NULL,
      NULL,
      NULL,
      NULL,
      37.960761,
      113.800142,
      0.832332,
      NULL,
      17,
      12.108727,
      79,
      38.590465,
      NULL,
      25,
      5.525690,
      48.076602,
      NULL,
      NULL,
      80.275577,
      NULL,
      0.980676,
      67.708785,
      1.316881,
      0.440453,
      86.666581,
      NULL,
      0.616671,
      220,
      57.054208,
      1.343897,
      NULL,
      0,
      18,
      2,
      1.589844,
      NULL,
      1,
      1.820129,
      0.286654,
      54.433232,
      2.945850,
      NULL,
      11,
      63,
      53.251339,
      1.334380,
      1,
      9.142105,
      NULL,
      3,
      NULL,
      13,
      1,
      73.153913,
      4,
      NULL,
      0,
      0.690132,
      8,
      5.574507,
      1,
      29.277511,
      NULL,
      27,
      18.377351,
      NULL,
      16.741788,
      3.629658,
      NULL,
      3,
      NULL,
      1.215565,
      1,
      NULL,
      68.875195,
      ' 3- 1-1974',
      ' 1-14-1991',
      ' 2-20-2000',
      ' 3- 4-2001',
      '11- 4-1997',
      '10-11-1978',
      ' 0-29-1992',
      NULL);
commit;
end;
/


