set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8527538';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2224',
      '10124301',
      '10423201',
      '40313214',
      '41212322',
      '20423110',
      '23100144',
      '42122403',
      '34100310',
      NULL,
      '04221244',
      '14233123',
      '02223044',
      NULL,
      '40003320',
      '34214400',
      NULL,
      '30114143',
      '12022300',
      NULL,
      NULL,
      '43044031',
      NULL,
      '04210401',
      '02410204',
      NULL,
      '41311003',
      '30400234',
      '24041123',
      '40232031',
      '31300311',
      '13320013',
      '14410110',
      '41342031',
      NULL,
      NULL,
      '00030143',
      NULL,
      '22010403',
      '11021422',
      '11241133',
      '20433300',
      '13230413',
      '14130413',
      '34100413',
      '',
      '',
      NULL,
      NULL,
      '1144310',
      NULL,
      18.099930,
      3,
      NULL,
      '324023',
      0.144402,
      ' 1-17-2003',
      ' 5- 1-1979',
      51,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      47.033001,
      4.779490,
      14.248408,
      79,
      109.376160,
      ' 5-29-1993',
      1.947328,
      0.161472,
      0.458134,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.641151,
      1.680517,
      0.161260,
      0.462820,
      NULL,
      0.678483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-25-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 4-1979',
      78.702584,
      NULL,
      NULL,
      32,
      126,
      53,
      32.555969,
      59.090895,
      20.585795,
      3.233120,
      NULL,
      70,
      ' 1-14-1982',
      19,
      11,
      16,
      19.766383,
      NULL,
      17,
      11.970781,
      NULL,
      0,
      2,
      ' 7-23-1981',
      NULL,
      NULL,
      15.622331,
      15,
      6.866385,
      NULL,
      NULL,
      22.681355,
      NULL,
      73.611123,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.886918,
      27,
      ' 4-20-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      92.057867,
      1,
      1.531524,
      108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      83,
      0.392099,
      1,
      NULL,
      1,
      1,
      44,
      0.219150,
      1.843398,
      NULL,
      23,
      NULL,
      NULL,
      0.968037,
      47,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      69.876235,
      NULL,
      NULL,
      NULL,
      5,
      4.366556,
      1,
      6.368252,
      1,
      3,
      1.872142,
      2.844138,
      0.904557,
      57.509802,
      1,
      72.780709,
      1.005301,
      2,
      NULL,
      3,
      3,
      9,
      63.313246,
      NULL,
      NULL,
      NULL,
      14.915219,
      3.095012,
      0,
      1,
      1.123270,
      1.818226,
      0,
      0.209759,
      68.907388,
      NULL,
      NULL,
      NULL,
      ' 9- 7-1994',
      ' 0-28-1979',
      NULL,
      ' 0-20-1976',
      NULL);
commit;
end;
/


